"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_AGENT_HEADER = exports.RESERVED_HEADERS = exports.PRODUCT_RESPONSE_HEADER = exports.PRODUCT_ORIGIN_HEADER = exports.DEFAULT_HEADERS = void 0;
exports.getDefaultHeaders = getDefaultHeaders;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */
const PRODUCT_RESPONSE_HEADER = exports.PRODUCT_RESPONSE_HEADER = 'x-elastic-product';

/**
 * @internal
 */
const PRODUCT_ORIGIN_HEADER = exports.PRODUCT_ORIGIN_HEADER = 'x-elastic-product-origin';

/**
 * @internal
 */
const USER_AGENT_HEADER = exports.USER_AGENT_HEADER = 'user-agent';

/**
 * @internal
 */
const RESERVED_HEADERS = exports.RESERVED_HEADERS = (0, _std.deepFreeze)([PRODUCT_ORIGIN_HEADER, USER_AGENT_HEADER]);

/**
 * @internal
 */
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = (0, _std.deepFreeze)({
  // Elasticsearch uses this to identify when a request is coming from Kibana, to allow Kibana to
  // access system indices using the standard ES APIs.
  [PRODUCT_ORIGIN_HEADER]: 'kibana'
});

/**
 * @internal
 */
function getDefaultHeaders(kibanaVersion) {
  return {
    ...DEFAULT_HEADERS,
    [USER_AGENT_HEADER]: `Kibana/${kibanaVersion}`
  };
}