"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlGroupInputBuilder = void 0;
exports.getDataControlPanelState = getDataControlPanelState;
exports.getOptionsListPanelState = getOptionsListPanelState;
exports.getRangeSliderPanelState = getRangeSliderPanelState;
exports.getTimeSliderPanelState = getTimeSliderPanelState;
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _common = require("../../../common");
var _control_group_constants = require("../../../common/control_group/control_group_constants");
var _types = require("../../../common/range_slider/types");
var _control_group_helpers = require("../embeddable/control_group_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const controlGroupInputBuilder = exports.controlGroupInputBuilder = {
  addDataControlFromField: async (initialInput, controlProps) => {
    const panelState = await getDataControlPanelState(initialInput, controlProps);
    initialInput.panels = {
      ...initialInput.panels,
      [panelState.explicitInput.id]: panelState
    };
  },
  addOptionsListControl: (initialInput, controlProps) => {
    const panelState = getOptionsListPanelState(initialInput, controlProps);
    initialInput.panels = {
      ...initialInput.panels,
      [panelState.explicitInput.id]: panelState
    };
  },
  addRangeSliderControl: (initialInput, controlProps) => {
    const panelState = getRangeSliderPanelState(initialInput, controlProps);
    initialInput.panels = {
      ...initialInput.panels,
      [panelState.explicitInput.id]: panelState
    };
  },
  addTimeSliderControl: initialInput => {
    const panelState = getTimeSliderPanelState(initialInput);
    initialInput.panels = {
      ...initialInput.panels,
      [panelState.explicitInput.id]: panelState
    };
  }
};
async function getDataControlPanelState(input, controlProps) {
  const {
    controlId,
    dataViewId,
    fieldName,
    title
  } = controlProps;
  return {
    type: await (0, _control_group_helpers.getCompatibleControlType)({
      dataViewId,
      fieldName
    }),
    ...getPanelState(input, controlProps),
    explicitInput: {
      id: controlId ? controlId : (0, _uuid.v4)(),
      dataViewId,
      fieldName,
      title: title !== null && title !== void 0 ? title : fieldName
    }
  };
}
function getOptionsListPanelState(input, controlProps) {
  const {
    controlId,
    dataViewId,
    fieldName,
    title,
    ...rest
  } = controlProps;
  return {
    type: _common.OPTIONS_LIST_CONTROL,
    ...getPanelState(input, controlProps),
    explicitInput: {
      id: controlId ? controlId : (0, _uuid.v4)(),
      dataViewId,
      fieldName,
      title: title !== null && title !== void 0 ? title : fieldName,
      ...rest
    }
  };
}
function getRangeSliderPanelState(input, controlProps) {
  const {
    controlId,
    dataViewId,
    fieldName,
    title,
    ...rest
  } = controlProps;
  return {
    type: _types.RANGE_SLIDER_CONTROL,
    ...getPanelState(input, controlProps),
    explicitInput: {
      id: controlId ? controlId : (0, _uuid.v4)(),
      dataViewId,
      fieldName,
      title: title !== null && title !== void 0 ? title : fieldName,
      ...rest
    }
  };
}
function getTimeSliderPanelState(input) {
  return {
    type: _common.TIME_SLIDER_CONTROL,
    order: (0, _control_group_helpers.getNextPanelOrder)(input.panels),
    grow: true,
    width: 'large',
    explicitInput: {
      id: (0, _uuid.v4)(),
      title: _i18n.i18n.translate('controls.controlGroup.timeSlider.title', {
        defaultMessage: 'Time slider'
      })
    }
  };
}
function getPanelState(input, controlProps) {
  var _ref, _controlProps$grow, _ref2, _controlProps$width;
  return {
    order: (0, _control_group_helpers.getNextPanelOrder)(input.panels),
    grow: (_ref = (_controlProps$grow = controlProps.grow) !== null && _controlProps$grow !== void 0 ? _controlProps$grow : input.defaultControlGrow) !== null && _ref !== void 0 ? _ref : _control_group_constants.DEFAULT_CONTROL_GROW,
    width: (_ref2 = (_controlProps$width = controlProps.width) !== null && _controlProps$width !== void 0 ? _controlProps$width : input.defaultControlWidth) !== null && _ref2 !== void 0 ? _ref2 : _control_group_constants.DEFAULT_CONTROL_WIDTH
  };
}