"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControlGroupContainer = exports.setFlyoutRef = exports.controlGroupSelector = exports.ControlGroupContainerContext = exports.ControlGroupContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _common = require("../../../common");
var _services = require("../../services");
var _control_group_component = require("../component/control_group_component");
var _open_add_data_control_flyout = require("../editor/open_add_data_control_flyout");
var _open_edit_control_group_flyout = require("../editor/open_edit_control_group_flyout");
var _control_group_input_builder = require("../external_api/control_group_input_builder");
var _control_group_diffing_integration = require("../state/control_group_diffing_integration");
var _control_group_reducers = require("../state/control_group_reducers");
var _types = require("../types");
var _control_group_chaining_system = require("./control_group_chaining_system");
var _control_group_helpers = require("./control_group_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let flyoutRef;
const setFlyoutRef = newRef => {
  flyoutRef = newRef;
};
exports.setFlyoutRef = setFlyoutRef;
const ControlGroupContainerContext = exports.ControlGroupContainerContext = /*#__PURE__*/(0, _react.createContext)(null);
const controlGroupSelector = exports.controlGroupSelector = _reactRedux.useSelector;
const useControlGroupContainer = () => {
  const controlGroup = (0, _react.useContext)(ControlGroupContainerContext);
  if (controlGroup == null) {
    throw new Error('useControlGroupContainer must be used inside ControlGroupContainerContext.');
  }
  return controlGroup;
};
exports.useControlGroupContainer = useControlGroupContainer;
class ControlGroupContainer extends _public.Container {
  constructor(reduxToolsPackage, initialInput, parent, initialComponentState, fieldFilterPredicate) {
    var _ControlGroupChaining;
    super(initialInput, {
      dataViewIds: [],
      embeddableLoaded: {},
      filters: []
    }, _services.pluginServices.getServices().controls.getControlFactory, parent, (_ControlGroupChaining = _control_group_chaining_system.ControlGroupChainingSystems[initialInput.chainingSystem]) === null || _ControlGroupChaining === void 0 ? void 0 : _ControlGroupChaining.getContainerSettings(initialInput));
    (0, _defineProperty2.default)(this, "type", _types.CONTROL_GROUP_TYPE);
    (0, _defineProperty2.default)(this, "anyControlOutputConsumerLoading$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "initialized$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "storageService", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "recalculateFilters$", void 0);
    (0, _defineProperty2.default)(this, "relevantDataViewId", void 0);
    (0, _defineProperty2.default)(this, "lastUsedDataViewId", void 0);
    (0, _defineProperty2.default)(this, "invalidSelectionsState", void 0);
    (0, _defineProperty2.default)(this, "diffingSubscription", new _rxjs.Subscription());
    // state management
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "store", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    (0, _defineProperty2.default)(this, "onFiltersPublished$", void 0);
    (0, _defineProperty2.default)(this, "onControlRemoved$", void 0);
    /** This currently reports the **entire** persistable control group input on unsaved changes */
    (0, _defineProperty2.default)(this, "unsavedChanges", void 0);
    (0, _defineProperty2.default)(this, "fieldFilterPredicate", void 0);
    (0, _defineProperty2.default)(this, "canShowInvalidSelectionsWarning", () => {
      var _this$storageService$;
      return (_this$storageService$ = this.storageService.getShowInvalidSelectionWarning()) !== null && _this$storageService$ !== void 0 ? _this$storageService$ : true;
    });
    (0, _defineProperty2.default)(this, "suppressInvalidSelectionsWarning", () => {
      this.storageService.setShowInvalidSelectionWarning(false);
    });
    (0, _defineProperty2.default)(this, "reportInvalidSelections", ({
      id,
      hasInvalidSelections
    }) => {
      this.invalidSelectionsState = {
        ...this.invalidSelectionsState,
        [id]: hasInvalidSelections
      };
      const childrenWithInvalidSelections = (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(this.getInput().panels).idsInOrder.filter(childId => {
        return this.invalidSelectionsState[childId];
      });
      this.dispatch.setControlWithInvalidSelectionsId(childrenWithInvalidSelections.length > 0 ? childrenWithInvalidSelections[0] : undefined);
    });
    (0, _defineProperty2.default)(this, "setupSubscriptions", () => {
      /**
       * refresh control order cache and make all panels refreshInputFromParent whenever panel orders change
       */
      this.subscriptions.add(this.getInput$().pipe((0, _rxjs.skip)(1), (0, _rxjs.distinctUntilChanged)((a, b) => (0, _control_group_chaining_system.controlOrdersAreEqual)(a.panels, b.panels))).subscribe(input => {
        this.recalculateDataViews();
        this.recalculateFilters$.next(null);
        const childOrderCache = (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(input.panels);
        childOrderCache.idsInOrder.forEach(id => {
          var _this$getChild;
          return (_this$getChild = this.getChild(id)) === null || _this$getChild === void 0 ? void 0 : _this$getChild.refreshInputFromParent();
        });
      }));

      /**
       * force publish filters when `showApplySelections` value changes to keep state clean
       */
      this.subscriptions.add(this.getInput$().pipe((0, _rxjs.distinctUntilChanged)((a, b) => Boolean(a.showApplySelections) === Boolean(b.showApplySelections)), (0, _rxjs.skip)(1)).subscribe(() => {
        const {
          filters,
          timeslice
        } = this.recalculateFilters();
        this.publishFilters({
          filters,
          timeslice
        });
      }));

      /**
       * run OnChildOutputChanged when any child's output has changed
       */
      this.subscriptions.add(this.getAnyChildOutputChange$().subscribe(childOutputChangedId => {
        this.recalculateDataViews();
        _control_group_chaining_system.ControlGroupChainingSystems[this.getInput().chainingSystem].onChildChange({
          childOutputChangedId,
          childOrder: (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(this.getInput().panels),
          getChild: id => this.getChild(id),
          recalculateFilters$: this.recalculateFilters$
        });
      }));

      /**
       * debounce output recalculation
       */
      this.subscriptions.add(this.recalculateFilters$.pipe((0, _rxjs.debounceTime)(10)).subscribe(() => {
        const {
          filters,
          timeslice
        } = this.recalculateFilters();
        this.tryPublishFilters({
          filters,
          timeslice
        });
      }));
    });
    (0, _defineProperty2.default)(this, "getPersistableInput", () => {
      const input = this.getInput();
      return (0, _lodash.pick)(input, [..._common.persistableControlGroupInputKeys, 'id']);
    });
    (0, _defineProperty2.default)(this, "updateInputAndReinitialize", newInput => {
      this.subscriptions.unsubscribe();
      this.subscriptions = new _rxjs.Subscription();
      this.initialized$.next(false);
      this.updateInput(newInput);
      this.untilAllChildrenReady().then(() => {
        this.recalculateDataViews();
        const {
          filters,
          timeslice
        } = this.recalculateFilters();
        this.publishFilters({
          filters,
          timeslice
        });
        this.setupSubscriptions();
        this.initialized$.next(true);
      });
    });
    (0, _defineProperty2.default)(this, "setLastUsedDataViewId", lastUsedDataViewId => {
      this.lastUsedDataViewId = lastUsedDataViewId;
    });
    (0, _defineProperty2.default)(this, "setRelevantDataViewId", newRelevantDataViewId => {
      this.relevantDataViewId = newRelevantDataViewId;
    });
    (0, _defineProperty2.default)(this, "getMostRelevantDataViewId", () => {
      var _this$lastUsedDataVie;
      return (_this$lastUsedDataVie = this.lastUsedDataViewId) !== null && _this$lastUsedDataVie !== void 0 ? _this$lastUsedDataVie : this.relevantDataViewId;
    });
    (0, _defineProperty2.default)(this, "openAddDataControlFlyout", _open_add_data_control_flyout.openAddDataControlFlyout);
    (0, _defineProperty2.default)(this, "openEditControlGroupFlyout", _open_edit_control_group_flyout.openEditControlGroupFlyout);
    (0, _defineProperty2.default)(this, "getPanelCount", () => {
      return Object.keys(this.getInput().panels).length;
    });
    (0, _defineProperty2.default)(this, "updateFilterContext", filters => {
      this.updateInput({
        filters
      });
    });
    (0, _defineProperty2.default)(this, "recalculateFilters", () => {
      const allFilters = [];
      let timeslice;
      const controlChildren = Object.values(this.children$.value);
      controlChildren.map(child => {
        var _childOutput$filters;
        const childOutput = child.getOutput();
        allFilters.push(...((_childOutput$filters = childOutput === null || childOutput === void 0 ? void 0 : childOutput.filters) !== null && _childOutput$filters !== void 0 ? _childOutput$filters : []));
        if (childOutput.timeslice) {
          timeslice = childOutput.timeslice;
        }
      });
      return {
        filters: (0, _esQuery.uniqFilters)(allFilters),
        timeslice
      };
    });
    /**
     * If apply button is enabled, add the new filters to the  unpublished filters component state;
     * otherwise, publish new filters right away
     */
    (0, _defineProperty2.default)(this, "tryPublishFilters", ({
      filters,
      timeslice
    }) => {
      var _this$output$filters;
      // if filters are different, try publishing them
      if (!(0, _esQuery.compareFilters)((_this$output$filters = this.output.filters) !== null && _this$output$filters !== void 0 ? _this$output$filters : [], filters !== null && filters !== void 0 ? filters : [], _esQuery.COMPARE_ALL_OPTIONS) || !(0, _lodash.isEqual)(this.output.timeslice, timeslice)) {
        const {
          explicitInput: {
            showApplySelections
          }
        } = this.getState();
        if (!showApplySelections) {
          this.publishFilters({
            filters,
            timeslice
          });
        } else {
          this.dispatch.setUnpublishedFilters({
            filters,
            timeslice
          });
        }
      } else {
        this.dispatch.setUnpublishedFilters(undefined);
      }
    });
    (0, _defineProperty2.default)(this, "publishFilters", ({
      filters,
      timeslice
    }) => {
      this.updateOutput({
        filters,
        timeslice
      });
      this.dispatch.setUnpublishedFilters(undefined);
      this.onFiltersPublished$.next(filters !== null && filters !== void 0 ? filters : []);
    });
    (0, _defineProperty2.default)(this, "recalculateDataViews", () => {
      const allDataViewIds = new Set();
      const controlChildren = Object.values(this.children$.value);
      controlChildren.map(child => {
        const dataViewId = child.getOutput().dataViewId;
        if (dataViewId) allDataViewIds.add(dataViewId);
      });
      this.updateOutput({
        dataViewIds: Array.from(allDataViewIds)
      });
    });
    (0, _defineProperty2.default)(this, "untilAllChildrenReady", () => {
      const panelsLoading = () => Object.keys(this.getInput().panels).some(panelId => !this.getOutput().embeddableLoaded[panelId]);
      if (panelsLoading()) {
        return new Promise((resolve, reject) => {
          const subscription = (0, _rxjs.merge)(this.getOutput$(), this.getInput$()).subscribe(() => {
            if (this.destroyed) {
              subscription.unsubscribe();
              reject();
            }
            if (!panelsLoading()) {
              subscription.unsubscribe();
              resolve();
            }
          });
        });
      }
      return Promise.resolve();
    });
    (0, _defineProperty2.default)(this, "untilInitialized", () => {
      if (this.initialized$.value === false) {
        return new Promise((resolve, reject) => {
          const subscription = this.initialized$.subscribe(isInitialized => {
            if (this.destroyed) {
              subscription.unsubscribe();
              reject();
            }
            if (isInitialized) {
              subscription.unsubscribe();
              resolve();
            }
          });
        });
      }
      return Promise.resolve();
    });
    ({
      storage: this.storageService
    } = _services.pluginServices.getServices());
    this.recalculateFilters$ = new _rxjs.Subject();
    this.onFiltersPublished$ = new _rxjs.Subject();
    this.onControlRemoved$ = new _rxjs.Subject();

    // start diffing control group state
    this.unsavedChanges = new _rxjs.BehaviorSubject(undefined);
    const diffingMiddleware = _control_group_diffing_integration.startDiffingControlGroupState.bind(this)();

    // build redux embeddable tools
    const reduxEmbeddableTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _control_group_reducers.controlGroupReducers,
      additionalMiddleware: [diffingMiddleware],
      initialComponentState
    });
    this.select = reduxEmbeddableTools.select;
    this.getState = reduxEmbeddableTools.getState;
    this.dispatch = reduxEmbeddableTools.dispatch;
    this.cleanupStateTools = reduxEmbeddableTools.cleanup;
    this.onStateChange = reduxEmbeddableTools.onStateChange;
    this.store = reduxEmbeddableTools.store;
    this.invalidSelectionsState = this.getChildIds().reduce((prev, id) => {
      return {
        ...prev,
        [id]: false
      };
    }, {});

    // when all children are ready setup subscriptions
    this.untilAllChildrenReady().then(() => {
      var _initialComponentStat, _initialComponentStat2;
      this.recalculateDataViews();
      this.setupSubscriptions();
      const {
        filters,
        timeslice
      } = this.recalculateFilters();
      this.publishFilters({
        filters,
        timeslice
      });
      this.calculateFiltersFromSelections((_initialComponentStat = initialComponentState === null || initialComponentState === void 0 ? void 0 : (_initialComponentStat2 = initialComponentState.lastSavedInput) === null || _initialComponentStat2 === void 0 ? void 0 : _initialComponentStat2.panels) !== null && _initialComponentStat !== void 0 ? _initialComponentStat : {}).then(filterOutput => {
        this.dispatch.setLastSavedFilters(filterOutput);
      });
      this.initialized$.next(true);
    });
    this.fieldFilterPredicate = fieldFilterPredicate;
  }
  setSavedState(lastSavedInput) {
    var _lastSavedInput$panel;
    this.calculateFiltersFromSelections((_lastSavedInput$panel = lastSavedInput === null || lastSavedInput === void 0 ? void 0 : lastSavedInput.panels) !== null && _lastSavedInput$panel !== void 0 ? _lastSavedInput$panel : {}).then(filterOutput => {
      (0, _reactRedux.batch)(() => {
        this.dispatch.setLastSavedInput(lastSavedInput);
        this.dispatch.setLastSavedFilters(filterOutput);
      });
    });
  }
  resetToLastSavedState() {
    const {
      explicitInput: {
        showApplySelections: currentShowApplySelections
      },
      componentState: {
        lastSavedInput
      }
    } = this.getState();
    if (lastSavedInput && !(0, _common.persistableControlGroupInputIsEqual)(this.getPersistableInput(), lastSavedInput)) {
      this.updateInput(lastSavedInput);
      if (currentShowApplySelections || lastSavedInput.showApplySelections) {
        /** If either the current or past state has auto-apply off, calling reset should force the changes to be published */
        this.calculateFiltersFromSelections(lastSavedInput.panels).then(filterOutput => {
          this.publishFilters(filterOutput);
        });
      }
      this.reload(); // this forces the children to update their inputs + perform validation as necessary
    }
  }
  reload() {
    super.reload();
  }
  closeAllFlyouts() {
    var _flyoutRef;
    (_flyoutRef = flyoutRef) === null || _flyoutRef === void 0 ? void 0 : _flyoutRef.close();
    flyoutRef = undefined;
  }
  async addDataControlFromField(controlProps) {
    const panelState = await (0, _control_group_input_builder.getDataControlPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState, this.getInput().panels);
  }
  addOptionsListControl(controlProps) {
    const panelState = (0, _control_group_input_builder.getOptionsListPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState, this.getInput().panels);
  }
  addRangeSliderControl(controlProps) {
    const panelState = (0, _control_group_input_builder.getRangeSliderPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState, this.getInput().panels);
  }
  addTimeSliderControl() {
    const panelState = (0, _control_group_input_builder.getTimeSliderPanelState)(this.getInput());
    return this.createAndSaveEmbeddable(panelState.type, panelState, this.getInput().panels);
  }
  async calculateFiltersFromSelections(panels) {
    let filtersArray = [];
    let timeslice;
    const controlChildren = Object.values(this.children$.value);
    await Promise.all(controlChildren.map(async child => {
      if (panels[child.id]) {
        var _await$selectionsToFi, _selectionsToFilters, _ref;
        const controlOutput = (_await$selectionsToFi = await ((_selectionsToFilters = (_ref = child).selectionsToFilters) === null || _selectionsToFilters === void 0 ? void 0 : _selectionsToFilters.call(_ref, panels[child.id].explicitInput))) !== null && _await$selectionsToFi !== void 0 ? _await$selectionsToFi : {};
        if (controlOutput.filters) {
          filtersArray = [...filtersArray, ...controlOutput.filters];
        } else if (controlOutput.timeslice) {
          timeslice = controlOutput.timeslice;
        }
      }
    }));
    return {
      filters: filtersArray,
      timeslice
    };
  }
  createNewPanelState(factory, partial = {}, otherPanels) {
    const {
      newPanel
    } = super.createNewPanelState(factory, partial);
    return {
      newPanel: {
        order: (0, _control_group_helpers.getNextPanelOrder)(this.getInput().panels),
        width: this.getInput().defaultControlWidth,
        grow: this.getInput().defaultControlGrow,
        ...newPanel
      },
      otherPanels
    };
  }
  onRemoveEmbeddable(idToRemove) {
    const newPanels = super.onRemoveEmbeddable(idToRemove);
    const childOrderCache = (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(this.getInput().panels);
    const removedOrder = childOrderCache.IdsToOrder[idToRemove];
    for (let i = removedOrder + 1; i < childOrderCache.idsInOrder.length; i++) {
      const currentOrder = newPanels[childOrderCache.idsInOrder[i]].order;
      newPanels[childOrderCache.idsInOrder[i]] = {
        ...newPanels[childOrderCache.idsInOrder[i]],
        order: currentOrder - 1
      };
    }
    this.onControlRemoved$.next(idToRemove);
    return newPanels;
  }
  getInheritedInput(id) {
    var _precedingFilters$fil;
    const {
      filters,
      query,
      ignoreParentSettings,
      timeRange,
      chainingSystem,
      panels
    } = this.getInput();
    const precedingFilters = _control_group_chaining_system.ControlGroupChainingSystems[chainingSystem].getPrecedingFilters({
      id,
      childOrder: (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(panels),
      getChild: getChildId => this.getChild(getChildId)
    });
    const allFilters = [...(ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreFilters ? [] : filters !== null && filters !== void 0 ? filters : []), ...((_precedingFilters$fil = precedingFilters === null || precedingFilters === void 0 ? void 0 : precedingFilters.filters) !== null && _precedingFilters$fil !== void 0 ? _precedingFilters$fil : [])];
    return {
      ignoreParentSettings,
      filters: allFilters,
      query: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreQuery ? undefined : query,
      timeRange: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreTimerange ? undefined : timeRange,
      timeslice: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreTimerange ? undefined : precedingFilters === null || precedingFilters === void 0 ? void 0 : precedingFilters.timeslice,
      id
    };
  }
  render(dom) {
    if (this.domNode) {
      _reactDom.default.unmountComponentAtNode(this.domNode);
    }
    this.domNode = dom;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
      theme: _services.pluginServices.getServices().core.theme
    }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.store
    }, /*#__PURE__*/_react.default.createElement(ControlGroupContainerContext.Provider, {
      value: this
    }, /*#__PURE__*/_react.default.createElement(_control_group_component.ControlGroup, null)))), dom);
  }
  destroy() {
    super.destroy();
    this.closeAllFlyouts();
    this.subscriptions.unsubscribe();
    this.cleanupStateTools();
    if (this.domNode) _reactDom.default.unmountComponentAtNode(this.domNode);
  }
}
exports.ControlGroupContainer = ControlGroupContainer;