"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupEditor = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _control_setting_tooltip_label = require("../../components/control_setting_tooltip_label");
var _control_group_strings = require("../control_group_strings");
var _editor_constants = require("./editor_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const editorControlGroupInputIsEqual = (a, b) => (0, _fastDeepEqual.default)(a, b);
const ControlGroupEditor = ({
  controlCount,
  initialInput,
  updateInput,
  onDeleteAll,
  onClose
}) => {
  var _controlGroupEditorSt2, _controlGroupEditorSt3, _controlGroupEditorSt4, _controlGroupEditorSt5;
  const [controlGroupEditorState, setControlGroupEditorState] = (0, _react.useState)({
    ...(0, _common.getDefaultControlGroupInput)(),
    ...initialInput
  });
  const updateControlGroupEditorSetting = (0, _react.useCallback)(newSettings => {
    setControlGroupEditorState({
      ...controlGroupEditorState,
      ...newSettings
    });
  }, [controlGroupEditorState]);
  const updateIgnoreSetting = (0, _react.useCallback)(newSettings => {
    var _controlGroupEditorSt;
    setControlGroupEditorState({
      ...controlGroupEditorState,
      ignoreParentSettings: {
        ...((_controlGroupEditorSt = controlGroupEditorState.ignoreParentSettings) !== null && _controlGroupEditorSt !== void 0 ? _controlGroupEditorSt : {}),
        ...newSettings
      }
    });
  }, [controlGroupEditorState]);
  const applyChangesToInput = (0, _react.useCallback)(() => {
    const inputToApply = {
      ...controlGroupEditorState
    };
    if (!editorControlGroupInputIsEqual(inputToApply, initialInput)) {
      updateInput(inputToApply);
    }
  }, [controlGroupEditorState, initialInput, updateInput]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _control_group_strings.ControlGroupStrings.management.getFlyoutTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-group-settings-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    options: _editor_constants.CONTROL_LAYOUT_OPTIONS,
    "data-test-subj": "control-group-layout-options",
    idSelected: controlGroupEditorState.controlStyle,
    legend: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionLegend(),
    onChange: newControlStyle => {
      // The UI copy calls this setting labelPosition, but to avoid an unnecessary migration it will be left as controlStyle in the state.
      updateControlGroupEditorSetting({
        controlStyle: newControlStyle
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getFilteringSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-filter-sync",
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getUseGlobalFiltersTitle(),
    onChange: e => updateIgnoreSetting({
      ignoreFilters: !e.target.checked,
      ignoreQuery: !e.target.checked
    }),
    checked: !Boolean((_controlGroupEditorSt2 = controlGroupEditorState.ignoreParentSettings) === null || _controlGroupEditorSt2 === void 0 ? void 0 : _controlGroupEditorSt2.ignoreFilters) || !Boolean((_controlGroupEditorSt3 = controlGroupEditorState.ignoreParentSettings) === null || _controlGroupEditorSt3 === void 0 ? void 0 : _controlGroupEditorSt3.ignoreQuery)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-query-sync-time-range",
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getUseGlobalTimeRangeTitle(),
    onChange: e => updateIgnoreSetting({
      ignoreTimerange: !e.target.checked
    }),
    checked: !Boolean((_controlGroupEditorSt4 = controlGroupEditorState.ignoreParentSettings) === null || _controlGroupEditorSt4 === void 0 ? void 0 : _controlGroupEditorSt4.ignoreTimerange)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.selectionSettings.getSelectionSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-validate-selections",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.validateSelections.getValidateSelectionsTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.validateSelections.getValidateSelectionsTooltip()
    }),
    checked: !Boolean((_controlGroupEditorSt5 = controlGroupEditorState.ignoreParentSettings) === null || _controlGroupEditorSt5 === void 0 ? void 0 : _controlGroupEditorSt5.ignoreValidations),
    onChange: e => updateIgnoreSetting({
      ignoreValidations: !e.target.checked
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-chaining",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.controlChaining.getHierarchyTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.controlChaining.getHierarchyTooltip()
    }),
    checked: controlGroupEditorState.chainingSystem === 'HIERARCHICAL',
    onChange: e => updateControlGroupEditorSetting({
      chainingSystem: e.target.checked ? 'HIERARCHICAL' : 'NONE'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-auto-apply-selections",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.showApplySelections.getShowApplySelectionsTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.showApplySelections.getShowApplySelectionsTooltip()
    }),
    checked: !controlGroupEditorState.showApplySelections,
    onChange: e => updateControlGroupEditorSetting({
      showApplySelections: !e.target.checked
    })
  }))), controlCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDeleteAll,
    "data-test-subj": "delete-all-controls-button",
    "aria-label": 'delete-all',
    iconType: "trash",
    color: "danger",
    flush: "left",
    size: "s"
  }, _control_group_strings.ControlGroupStrings.management.getDeleteAllButtonTitle()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-editing-group`,
    iconType: "cross",
    onClick: () => {
      onClose();
    }
  }, _control_group_strings.ControlGroupStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-group`,
    iconType: "check",
    color: "primary",
    "data-test-subj": "control-group-editor-save",
    onClick: () => {
      applyChangesToInput();
      onClose();
    }
  }, _control_group_strings.ControlGroupStrings.manageControl.getSaveChangesTitle())))));
};
exports.ControlGroupEditor = ControlGroupEditor;