"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlEditor = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _common = require("../../../common");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _data_control_editor_tools = require("./data_control_editor_tools");
var _editor_constants = require("./editor_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPicker = (0, _public.withSuspense)(_public.LazyFieldPicker, null);
const DataViewPicker = (0, _public.withSuspense)(_public.LazyDataViewPicker, null);
const ControlEditor = ({
  embeddable,
  isCreate,
  width,
  grow,
  onSave,
  onCancel,
  removeControl,
  getRelevantDataViewId,
  setLastUsedDataViewId
}) => {
  var _embeddable$getTitle, _selectedDataView$get;
  const {
    dataViews: {
      getIdsWithTitle,
      getDefaultId,
      get
    },
    controls: {
      getControlFactory,
      getControlTypes
    }
  } = _services.pluginServices.getServices();
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();
  const editorConfig = controlGroup.select(state => state.componentState.editorConfig);
  const [currentGrow, setCurrentGrow] = (0, _react.useState)(grow);
  const [currentWidth, setCurrentWidth] = (0, _react.useState)(width);
  const [defaultTitle, setDefaultTitle] = (0, _react.useState)();
  const [currentTitle, setCurrentTitle] = (0, _react.useState)((_embeddable$getTitle = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getTitle()) !== null && _embeddable$getTitle !== void 0 ? _embeddable$getTitle : '');
  const [controlEditorValid, setControlEditorValid] = (0, _react.useState)(false);
  const [selectedDataViewId, setSelectedDataViewId] = (0, _react.useState)();
  const [selectedField, setSelectedField] = (0, _react.useState)(embeddable ? embeddable.getInput().fieldName : undefined);
  const [selectedControlType, setSelectedControlType] = (0, _react.useState)(embeddable ? embeddable.type : undefined);
  const [customSettings, setCustomSettings] = (0, _react.useState)();
  const currentInput = (0, _react.useMemo)(() => ({
    fieldName: selectedField,
    dataViewId: selectedDataViewId,
    title: currentTitle === '' ? defaultTitle !== null && defaultTitle !== void 0 ? defaultTitle : selectedField : currentTitle,
    ...customSettings
  }), [currentTitle, defaultTitle, selectedField, selectedDataViewId, customSettings]);
  const startingInput = (0, _react.useRef)(currentInput);
  (0, _useMount.default)(() => {
    let mounted = true;
    if (selectedField) setDefaultTitle(selectedField);
    (async (_ref, _ref2, _embeddable$getInput$, _controlGroup$getOutp) => {
      if (!mounted) return;
      const initialId = (_ref = (_ref2 = (_embeddable$getInput$ = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput().dataViewId) !== null && _embeddable$getInput$ !== void 0 ? _embeddable$getInput$ : (_controlGroup$getOutp = controlGroup.getOutput().dataViewIds) === null || _controlGroup$getOutp === void 0 ? void 0 : _controlGroup$getOutp[0]) !== null && _ref2 !== void 0 ? _ref2 : getRelevantDataViewId === null || getRelevantDataViewId === void 0 ? void 0 : getRelevantDataViewId()) !== null && _ref !== void 0 ? _ref : await getDefaultId();
      if (initialId) {
        setSelectedDataViewId(initialId);
        startingInput.current = {
          ...startingInput.current,
          dataViewId: initialId
        };
      }
    })();
    return () => {
      mounted = false;
    };
  });
  const {
    loading: dataViewListLoading,
    value: dataViewListItems = []
  } = (0, _useAsync.default)(() => {
    return getIdsWithTitle();
  });
  const {
    loading: dataViewLoading,
    value: {
      selectedDataView,
      fieldRegistry
    } = {
      selectedDataView: undefined,
      fieldRegistry: undefined
    }
  } = (0, _useAsync.default)(async () => {
    if (!selectedDataViewId) {
      return;
    }
    const dataView = await get(selectedDataViewId);
    const registry = await (0, _data_control_editor_tools.getDataControlFieldRegistry)(dataView);
    return {
      selectedDataView: dataView,
      fieldRegistry: registry
    };
  }, [selectedDataViewId]);
  (0, _react.useEffect)(() => setControlEditorValid(Boolean(selectedField) && Boolean(selectedDataView) && Boolean(selectedControlType)), [selectedField, setControlEditorValid, selectedDataView, selectedControlType]);
  const CompatibleControlTypesComponent = (0, _react.useMemo)(() => {
    const allDataControlTypes = getControlTypes().filter(type => type !== _common.TIME_SLIDER_CONTROL);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
      "data-test-subj": `controlTypeMenu`,
      "aria-label": _control_group_strings.ControlGroupStrings.manageControl.dataSource.getControlTypeTitle()
    }, allDataControlTypes.map(controlType => {
      var _fieldRegistry$select;
      const factory = getControlFactory(controlType);
      const disabled = fieldRegistry && selectedField ? !((_fieldRegistry$select = fieldRegistry[selectedField]) !== null && _fieldRegistry$select !== void 0 && _fieldRegistry$select.compatibleControlTypes.includes(controlType)) : true;
      const keyPadMenuItem = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
        key: controlType,
        id: `create__${controlType}`,
        "aria-label": factory.getDisplayName(),
        "data-test-subj": `create__${controlType}`,
        isSelected: controlType === selectedControlType,
        disabled: disabled,
        onClick: () => setSelectedControlType(controlType),
        label: factory.getDisplayName()
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: factory.getIconType(),
        size: "l"
      }));
      return disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        key: `disabled__${controlType}`,
        content: _control_group_strings.ControlGroupStrings.manageControl.dataSource.getControlTypeErrorMessage({
          fieldSelected: Boolean(selectedField),
          controlType
        })
      }, keyPadMenuItem) : keyPadMenuItem;
    }));
  }, [selectedField, fieldRegistry, getControlFactory, getControlTypes, selectedControlType]);
  const CustomSettingsComponent = (0, _react.useMemo)(() => {
    if (!selectedControlType || !selectedField || !fieldRegistry) return;
    const controlFactory = getControlFactory(selectedControlType);
    const CustomSettings = controlFactory.controlEditorOptionsComponent;
    if (!CustomSettings) return;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      ratio: "third",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _control_group_strings.ControlGroupStrings.manageControl.controlTypeSettings.getFormGroupTitle(controlFactory.getDisplayName())),
      description: _control_group_strings.ControlGroupStrings.manageControl.controlTypeSettings.getFormGroupDescription(controlFactory.getDisplayName()),
      "data-test-subj": "control-editor-custom-settings"
    }, /*#__PURE__*/_react.default.createElement(CustomSettings, {
      onChange: settings => setCustomSettings(settings),
      initialInput: embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput(),
      fieldType: fieldRegistry[selectedField].field.type,
      setControlEditorValid: setControlEditorValid
    }));
  }, [selectedControlType, selectedField, getControlFactory, fieldRegistry, embeddable]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isCreate ? _control_group_strings.ControlGroupStrings.manageControl.getFlyoutCreateTitle() : _control_group_strings.ControlGroupStrings.manageControl.getFlyoutEditTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-editor-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _control_group_strings.ControlGroupStrings.manageControl.dataSource.getFormGroupTitle()),
    description: _control_group_strings.ControlGroupStrings.manageControl.dataSource.getFormGroupDescription()
  }, !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideDataViewSelector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.dataSource.getDataViewTitle()
  }, /*#__PURE__*/_react.default.createElement(DataViewPicker, {
    dataViews: dataViewListItems,
    selectedDataViewId: selectedDataViewId,
    onChangeDataViewId: newDataViewId => {
      setLastUsedDataViewId === null || setLastUsedDataViewId === void 0 ? void 0 : setLastUsedDataViewId(newDataViewId);
      if (newDataViewId === selectedDataViewId) return;
      setSelectedField(undefined);
      setSelectedDataViewId(newDataViewId);
    },
    trigger: {
      label: (_selectedDataView$get = selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) !== null && _selectedDataView$get !== void 0 ? _selectedDataView$get : _control_group_strings.ControlGroupStrings.manageControl.dataSource.getSelectDataViewMessage()
    },
    selectableProps: {
      isLoading: dataViewListLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.dataSource.getFieldTitle()
  }, /*#__PURE__*/_react.default.createElement(FieldPicker, {
    filterPredicate: field => {
      var _controlGroup$fieldFi, _controlGroup$fieldFi2;
      const customPredicate = (_controlGroup$fieldFi = (_controlGroup$fieldFi2 = controlGroup.fieldFilterPredicate) === null || _controlGroup$fieldFi2 === void 0 ? void 0 : _controlGroup$fieldFi2.call(controlGroup, field)) !== null && _controlGroup$fieldFi !== void 0 ? _controlGroup$fieldFi : true;
      return Boolean(fieldRegistry === null || fieldRegistry === void 0 ? void 0 : fieldRegistry[field.name]) && customPredicate;
    },
    selectedFieldName: selectedField,
    dataView: selectedDataView,
    onSelectField: field => {
      var _field$displayName, _fieldRegistry$field$;
      const newDefaultTitle = (_field$displayName = field.displayName) !== null && _field$displayName !== void 0 ? _field$displayName : field.name;
      setDefaultTitle(newDefaultTitle);
      setSelectedField(field.name);
      setSelectedControlType(fieldRegistry === null || fieldRegistry === void 0 ? void 0 : (_fieldRegistry$field$ = fieldRegistry[field.name]) === null || _fieldRegistry$field$ === void 0 ? void 0 : _fieldRegistry$field$.compatibleControlTypes[0]);
      if (!currentTitle || currentTitle === defaultTitle) {
        setCurrentTitle(newDefaultTitle);
      }
    },
    selectableProps: {
      isLoading: dataViewListLoading || dataViewLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.dataSource.getControlTypeTitle()
  }, CompatibleControlTypesComponent)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _control_group_strings.ControlGroupStrings.manageControl.displaySettings.getFormGroupTitle()),
    description: _control_group_strings.ControlGroupStrings.manageControl.displaySettings.getFormGroupDescription()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.displaySettings.getTitleInputTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "control-editor-title-input",
    placeholder: defaultTitle,
    value: currentTitle,
    onChange: e => setCurrentTitle(e.target.value)
  })), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideWidthSettings) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.displaySettings.getWidthInputTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    legend: _control_group_strings.ControlGroupStrings.management.controlWidth.getWidthSwitchLegend(),
    options: _editor_constants.CONTROL_WIDTH_OPTIONS,
    idSelected: currentWidth,
    onChange: newWidth => setCurrentWidth(newWidth)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _control_group_strings.ControlGroupStrings.manageControl.displaySettings.getGrowSwitchTitle(),
    color: "primary",
    checked: currentGrow,
    onChange: () => setCurrentGrow(!currentGrow),
    "data-test-subj": "control-editor-grow-switch"
  })))), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideAdditionalSettings) ? CustomSettingsComponent : null, removeControl && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `delete-${currentInput.title}`,
    iconType: "trash",
    flush: "left",
    color: "danger",
    onClick: () => {
      onCancel({
        input: currentInput,
        grow: currentGrow,
        width: currentWidth
      });
      removeControl();
    }
  }, _control_group_strings.ControlGroupStrings.management.getDeleteButtonTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-${currentInput.title}`,
    "data-test-subj": "control-editor-cancel",
    iconType: "cross",
    onClick: () => {
      const inputToReturn = isCreate && (0, _fastDeepEqual.default)(startingInput.current, currentInput) ? {} : currentInput;
      onCancel({
        input: inputToReturn,
        grow: currentGrow,
        width: currentWidth
      });
    }
  }, _control_group_strings.ControlGroupStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-${currentInput.title}`,
    "data-test-subj": "control-editor-save",
    iconType: "check",
    color: "primary",
    disabled: !controlEditorValid,
    onClick: () => onSave({
      input: currentInput,
      grow: currentGrow,
      width: currentWidth
    }, selectedControlType)
  }, _control_group_strings.ControlGroupStrings.manageControl.getSaveChangesTitle())))));
};
exports.ControlEditor = ControlEditor;