"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroup = void 0;
require("../control_group.scss");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _core = require("@dnd-kit/core");
var _sortable = require("@dnd-kit/sortable");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _control_group_sortable_item = require("./control_group_sortable_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlGroup = () => {
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();

  // current state
  const panels = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.panels);
  const viewMode = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.viewMode);
  const controlStyle = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.controlStyle);
  const showApplySelections = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.showApplySelections);
  const showAddButton = (0, _control_group_container.controlGroupSelector)(state => state.componentState.showAddButton);
  const unpublishedFilters = (0, _control_group_container.controlGroupSelector)(state => state.componentState.unpublishedFilters);
  const controlWithInvalidSelectionsId = (0, _control_group_container.controlGroupSelector)(state => state.componentState.controlWithInvalidSelectionsId);
  const [tourStepOpen, setTourStepOpen] = (0, _react.useState)(true);
  const [suppressTourChecked, setSuppressTourChecked] = (0, _react.useState)(false);
  const [renderTourStep, setRenderTourStep] = (0, _react.useState)(false);
  const isEditable = viewMode === _public.ViewMode.EDIT;
  const idsInOrder = (0, _react.useMemo)(() => Object.values(panels).sort((a, b) => a.order > b.order ? 1 : -1).reduce((acc, panel) => {
    acc.push(panel.explicitInput.id);
    return acc;
  }, []), [panels]);
  (0, _react.useEffect)(() => {
    /**
     * This forces the tour step to get unmounted so that it can attach to the new invalid
     * control - otherwise, the anchor will remain attached to the old invalid control
     */
    let mounted = true;
    setRenderTourStep(false);
    setTimeout(() => {
      if (mounted) {
        setRenderTourStep(true);
      }
    }, 100);
    return () => {
      mounted = false;
    };
  }, [controlWithInvalidSelectionsId]);
  const applyButtonEnabled = (0, _react.useMemo)(() => {
    /**
     * this is undefined if there are no unpublished filters / timeslice; note that an empty filter array counts
     * as unpublished filters and so the apply button should still be enabled in this case
     */
    return Boolean(unpublishedFilters);
  }, [unpublishedFilters]);
  const showAppendedButtonGroup = (0, _react.useMemo)(() => showAddButton || showApplySelections, [showAddButton, showApplySelections]);
  const ApplyButtonComponent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "m",
      disabled: !applyButtonEnabled,
      iconSize: "m",
      display: "fill",
      color: 'success',
      iconType: 'check',
      "data-test-subj": "controlGroup--applyFiltersButton",
      "aria-label": _control_group_strings.ControlGroupStrings.management.getApplyButtonTitle(applyButtonEnabled),
      onClick: () => {
        if (unpublishedFilters) controlGroup.publishFilters(unpublishedFilters);
      }
    });
  }, [applyButtonEnabled, unpublishedFilters, controlGroup]);
  const tourStep = (0, _react.useMemo)(() => {
    if (!renderTourStep || !controlGroup.canShowInvalidSelectionsWarning() || !tourStepOpen || !controlWithInvalidSelectionsId) {
      return null;
    }
    const invalidControlType = panels[controlWithInvalidSelectionsId].type;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      step: 1,
      stepsTotal: 1,
      minWidth: 300,
      maxWidth: 300,
      display: "block",
      isStepOpen: true,
      repositionOnScroll: true,
      onFinish: () => {},
      panelPaddingSize: "m",
      anchorPosition: "downCenter",
      panelClassName: "controlGroup--invalidSelectionsTour",
      anchor: `#controlFrame--${controlWithInvalidSelectionsId}`,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _control_group_strings.ControlGroupStrings.invalidControlWarning.getTourTitle())),
      content: _control_group_strings.ControlGroupStrings.invalidControlWarning.getTourContent(invalidControlType),
      footerAction: [/*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        compressed: true,
        checked: suppressTourChecked,
        id: 'controlGroup--suppressTourCheckbox',
        className: "controlGroup--suppressTourCheckbox",
        onChange: e => setSuppressTourChecked(e.target.checked),
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: "controlGroup--suppressTourCheckboxLabel"
        }, _control_group_strings.ControlGroupStrings.invalidControlWarning.getSuppressTourLabel())
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        flush: "right",
        color: "text",
        onClick: () => {
          setTourStepOpen(false);
          if (suppressTourChecked) {
            controlGroup.suppressInvalidSelectionsWarning();
          }
        }
      }, _control_group_strings.ControlGroupStrings.invalidControlWarning.getDismissButton())]
    });
  }, [panels, controlGroup, tourStepOpen, renderTourStep, suppressTourChecked, controlWithInvalidSelectionsId]);
  const [draggingId, setDraggingId] = (0, _react.useState)(null);
  const draggingIndex = (0, _react.useMemo)(() => draggingId ? idsInOrder.indexOf(draggingId) : -1, [idsInOrder, draggingId]);
  const sensors = (0, _core.useSensors)((0, _core.useSensor)(_core.PointerSensor), (0, _core.useSensor)(_core.KeyboardSensor, {
    coordinateGetter: _sortable.sortableKeyboardCoordinates
  }));
  const onDragEnd = ({
    over
  }) => {
    var _document$activeEleme;
    if (over) {
      const overIndex = idsInOrder.indexOf(over.id);
      if (draggingIndex !== overIndex) {
        const newIndex = overIndex;
        controlGroup.dispatch.setControlOrders({
          ids: (0, _sortable.arrayMove)([...idsInOrder], draggingIndex, newIndex)
        });
      }
    }
    (_document$activeEleme = document.activeElement) === null || _document$activeEleme === void 0 ? void 0 : _document$activeEleme.blur();
    setDraggingId(null);
  };
  const emptyState = !(idsInOrder && idsInOrder.length > 0);
  // Empty, non-editable view is null
  if (!isEditable && emptyState) {
    return null;
  }
  let panelBg = 'transparent';
  if (emptyState) panelBg = 'plain';
  if (draggingId) panelBg = 'success';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, idsInOrder.length > 0 || showAddButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    color: panelBg,
    paddingSize: emptyState ? 's' : 'none',
    "data-test-subj": "controls-group-wrapper",
    className: (0, _classnames.default)('controlsWrapper', {
      'controlsWrapper--empty': emptyState,
      'controlsWrapper--twoLine': controlStyle === 'twoLine'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    gutterSize: "s",
    direction: "row",
    responsive: false,
    alignItems: "stretch",
    justifyContent: "center",
    "data-test-subj": "controls-group"
  }, tourStep, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_core.DndContext, {
    onDragStart: ({
      active
    }) => setDraggingId(active.id),
    onDragEnd: onDragEnd,
    onDragCancel: () => setDraggingId(null),
    sensors: sensors,
    collisionDetection: _core.closestCenter,
    layoutMeasuring: {
      strategy: _core.LayoutMeasuringStrategy.Always
    }
  }, /*#__PURE__*/_react.default.createElement(_sortable.SortableContext, {
    items: idsInOrder,
    strategy: _sortable.rectSortingStrategy
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: (0, _classnames.default)('controlGroup', {
      'controlGroup-isDragging': draggingId
    }),
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, idsInOrder.map((controlId, index) => panels[controlId] && /*#__PURE__*/_react.default.createElement(_control_group_sortable_item.SortableControl, {
    isEditable: isEditable,
    dragInfo: {
      index,
      draggingIndex
    },
    embeddableId: controlId,
    embeddableType: panels[controlId].type,
    key: controlId
  })))), /*#__PURE__*/_react.default.createElement(_core.DragOverlay, null, draggingId ? /*#__PURE__*/_react.default.createElement(_control_group_sortable_item.ControlClone, {
    draggingId: draggingId
  }) : null))), showAppendedButtonGroup && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "controlGroup--endButtonGroup",
    "data-test-subj": "controlGroup--endButtonGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, showAddButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _control_group_strings.ControlGroupStrings.management.getAddControlTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "m",
    iconSize: "m",
    display: "base",
    iconType: 'plusInCircle',
    "data-test-subj": "controlGroup--addControlButton",
    "aria-label": _control_group_strings.ControlGroupStrings.management.getAddControlTitle(),
    onClick: () => controlGroup.openAddDataControlFlyout()
  }))), showApplySelections && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, applyButtonEnabled ? ApplyButtonComponent : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _control_group_strings.ControlGroupStrings.management.getApplyButtonTitle(false)
  }, ApplyButtonComponent)))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
};
exports.ControlGroup = ControlGroup;