"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditControlFlyout = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _control_editor = require("../editor/control_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EditControlFlyout = ({
  embeddable,
  closeFlyout,
  removeControl
}) => {
  // Controls Services Context
  const {
    overlays: {
      openConfirm
    },
    controls: {
      getControlFactory
    }
  } = _services.pluginServices.getServices();
  // Redux embeddable container Context
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();

  // current state
  const panels = controlGroup.select(state => state.explicitInput.panels);
  const panel = panels[embeddable.id];
  const onCancel = changes => {
    if ((0, _lodash.isEqual)(panel.explicitInput, {
      ...panel.explicitInput,
      ...changes.input
    }) && changes.grow === panel.grow && changes.width === panel.width) {
      closeFlyout();
      return;
    }
    openConfirm(_control_group_strings.ControlGroupStrings.management.discardChanges.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.discardChanges.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.discardChanges.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.discardChanges.getTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        closeFlyout();
      }
    });
  };
  const onSave = async (changes, type) => {
    if (!type) {
      closeFlyout();
      return;
    }
    const factory = getControlFactory(type);
    if (!factory) throw new _public.EmbeddableFactoryNotFoundError(type);
    let inputToReturn = changes.input;
    if (factory.presaveTransformFunction) {
      inputToReturn = factory.presaveTransformFunction(inputToReturn, embeddable);
    }
    if (changes.width && changes.width !== panel.width) controlGroup.dispatch.setControlWidth({
      width: changes.width,
      embeddableId: embeddable.id
    });
    if (changes.grow !== undefined && changes.grow !== panel.grow) {
      controlGroup.dispatch.setControlGrow({
        grow: changes.grow,
        embeddableId: embeddable.id
      });
    }
    closeFlyout();
    if (panel.type === type) {
      controlGroup.updateInputForChild(embeddable.id, inputToReturn);
    } else {
      await controlGroup.replaceEmbeddable(embeddable.id, inputToReturn, type);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
    isCreate: false,
    width: panel.width,
    grow: panel.grow,
    embeddable: embeddable,
    onCancel: onCancel,
    setLastUsedDataViewId: lastUsed => controlGroup.setLastUsedDataViewId(lastUsed),
    onSave: onSave,
    removeControl: () => {
      closeFlyout();
      removeControl();
    }
  });
};
exports.EditControlFlyout = EditControlFlyout;