"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = void 0;
var _schemas = require("../../../common/schemas");
var _content_client = require("../../content_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const create = exports.create = {
  schemas: _schemas.rpcSchemas.create,
  fn: async (ctx, {
    contentTypeId,
    version,
    data,
    options
  }) => {
    const clientFactory = (0, _content_client.getContentClientFactory)({
      contentRegistry: ctx.contentRegistry
    });
    const client = clientFactory(contentTypeId).getForRequest({
      ...ctx,
      version
    });
    return client.create(data, options);
  }
};