"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Core = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _savedObjectsSettings = require("@kbn/saved-objects-settings");
var _content_client = require("../content_client");
var _event_bus = require("./event_bus");
var _registry = require("./registry");
var _msearch = require("./msearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Core {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "contentRegistry", void 0);
    (0, _defineProperty2.default)(this, "eventBus", void 0);
    this.ctx = ctx;
    const contentTypeValidator = contentType => {
      var _this$contentRegistry, _this$contentRegistry2;
      return (_this$contentRegistry = (_this$contentRegistry2 = this.contentRegistry) === null || _this$contentRegistry2 === void 0 ? void 0 : _this$contentRegistry2.isContentRegistered(contentType)) !== null && _this$contentRegistry !== void 0 ? _this$contentRegistry : false;
    };
    this.eventBus = new _event_bus.EventBus(contentTypeValidator);
    this.contentRegistry = new _registry.ContentRegistry(this.eventBus);
  }
  setup() {
    this.setupEventStream();
    const coreApi = {
      register: this.contentRegistry.register.bind(this.contentRegistry),
      crud: this.contentRegistry.getCrud.bind(this.contentRegistry),
      eventBus: this.eventBus,
      contentClient: {
        getForRequest: this.getContentClientForRequest.bind(this)
      }
    };
    return {
      contentRegistry: this.contentRegistry,
      api: coreApi
    };
  }
  setupEventStream() {
    const eventStream = this.ctx.eventStream;

    // TODO: This should be cleaned up and support added for all CRUD events.
    // The work is tracked here: https://github.com/elastic/kibana/issues/153258
    // and here: https://github.com/elastic/kibana/issues/153260
    if (eventStream) {
      this.eventBus.on('deleteItemSuccess', event => {
        eventStream.addEvent({
          // TODO: add "subject" field to event
          predicate: ['delete'],
          // TODO: the `.contentId` should be easily available on most events.
          object: [event.contentTypeId, event.contentId]
        });
      });
    }
  }
  getContentClientForRequest({
    requestHandlerContext,
    request
  }) {
    /** Handler to return a ContentClient for a specific content type Id and request version */
    const forFn = (contentTypeId, version) => {
      const contentDefinition = this.contentRegistry.getDefinition(contentTypeId);
      const clientFactory = (0, _content_client.getContentClientFactory)({
        contentRegistry: this.contentRegistry
      });
      const contentClient = clientFactory(contentTypeId);
      return contentClient.getForRequest({
        requestHandlerContext,
        request,
        version: version !== null && version !== void 0 ? version : contentDefinition.version.latest
      });
    };
    const mSearchService = new _msearch.MSearchService({
      getSavedObjectsClient: async () => (await requestHandlerContext.core).savedObjects.client,
      contentRegistry: this.contentRegistry,
      getConfig: {
        listingLimit: async () => (await requestHandlerContext.core).uiSettings.client.get(_savedObjectsSettings.LISTING_LIMIT_SETTING),
        perPage: async () => (await requestHandlerContext.core).uiSettings.client.get(_savedObjectsSettings.PER_PAGE_SETTING)
      }
    });
    const msearchClientFactory = (0, _content_client.getMSearchClientFactory)({
      contentRegistry: this.contentRegistry,
      mSearchService
    });
    const msearchClient = msearchClientFactory({
      requestHandlerContext,
      request
    });
    return {
      for: forFn,
      msearch: msearchClient.msearch
    };
  }
}
exports.Core = Core;