"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchSchemas = exports.searchResultSchema = exports.searchQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const searchQuerySchema = exports.searchQuerySchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  text: _configSchema.schema.maybe(_configSchema.schema.string()),
  tags: _configSchema.schema.maybe(_configSchema.schema.object({
    included: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    excluded: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  })),
  limit: _configSchema.schema.maybe(_configSchema.schema.number()),
  cursor: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'forbid'
})]);
const searchResultSchema = exports.searchResultSchema = _configSchema.schema.object({
  hits: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  pagination: _configSchema.schema.object({
    total: _configSchema.schema.number(),
    cursor: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});
const searchSchemas = exports.searchSchemas = {
  in: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    version: _constants.versionSchema,
    query: searchQuerySchema,
    options: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  }),
  out: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    result: searchResultSchema,
    meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  })
};