"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemas = void 0;
var _get = require("./get");
var _bulk_get = require("./bulk_get");
var _create = require("./create");
var _update = require("./update");
var _delete = require("./delete");
var _search = require("./search");
var _msearch = require("./msearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const schemas = exports.schemas = {
  get: _get.getSchemas,
  bulkGet: _bulk_get.bulkGetSchemas,
  create: _create.createSchemas,
  update: _update.updateSchemas,
  delete: _delete.deleteSchemas,
  search: _search.searchSchemas,
  mSearch: _msearch.mSearchSchemas
};