"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSchemas = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const deleteSchemas = exports.deleteSchemas = {
  in: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    id: _configSchema.schema.string({
      minLength: 1
    }),
    version: _constants.versionSchema,
    options: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  }),
  out: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    result: _configSchema.schema.object({
      success: _configSchema.schema.boolean()
    }, {
      unknowns: 'forbid'
    })
  }, {
    unknowns: 'forbid'
  })
};