"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/dev-tools-plugin/public");
var _embeddable = require("./application/containers/embeddable");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class ConsoleUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "autocompleteInfo", new _services.AutocompleteInfo());
    (0, _defineProperty2.default)(this, "_embeddableConsole", void 0);
    this.ctx = ctx;
    const storage = (0, _services.createStorage)({
      engine: window.localStorage,
      prefix: 'sense:'
    });
    (0, _services.setStorage)(storage);
    this._embeddableConsole = new _services.EmbeddableConsoleInfo(storage);
  }
  setup({
    notifications,
    getStartServices,
    http
  }, {
    devTools,
    home,
    share,
    usageCollection
  }) {
    const {
      ui: {
        enabled: isConsoleUiEnabled
      },
      dev: {
        enableMonaco: isMonacoEnabled
      }
    } = this.ctx.config.get();
    this.autocompleteInfo.setup(http);
    (0, _services.setAutocompleteInfo)(this.autocompleteInfo);
    if (isConsoleUiEnabled) {
      if (home) {
        home.featureCatalogue.register({
          id: 'console',
          title: _i18n.i18n.translate('console.devToolsTitle', {
            defaultMessage: 'Interact with the Elasticsearch API'
          }),
          description: _i18n.i18n.translate('console.devToolsDescription', {
            defaultMessage: 'Skip cURL and use a JSON interface to work with your data in Console.'
          }),
          icon: 'consoleApp',
          path: '/app/dev_tools#/console',
          showOnHomePage: false,
          category: 'admin'
        });
      }
      devTools.register({
        id: 'console',
        order: 1,
        title: _i18n.i18n.translate('console.consoleDisplayName', {
          defaultMessage: 'Console'
        }),
        enableRouting: false,
        mount: async ({
          element,
          theme$
        }) => {
          const [core] = await getStartServices();
          const {
            i18n: {
              Context: I18nContext
            },
            docLinks: {
              DOC_LINK_VERSION,
              links
            }
          } = core;
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          return renderApp({
            http,
            docLinkVersion: DOC_LINK_VERSION,
            docLinks: links,
            I18nContext,
            notifications,
            usageCollection,
            element,
            theme$,
            autocompleteInfo: this.autocompleteInfo,
            isMonacoEnabled
          });
        }
      });
      const locator = share.url.locators.create({
        id: 'CONSOLE_APP_LOCATOR',
        getLocation: async ({
          loadFrom
        }) => {
          return {
            app: 'dev_tools',
            path: `#/console${loadFrom ? `?load_from=${loadFrom}` : ''}`,
            state: {
              loadFrom
            }
          };
        }
      });
      return {
        locator
      };
    }
    return {};
  }
  start(core, deps) {
    var _core$application$cap, _core$application$cap2;
    const {
      ui: {
        enabled: isConsoleUiEnabled,
        embeddedEnabled: isEmbeddedConsoleEnabled
      }
    } = this.ctx.config.get();
    const consoleStart = {};
    const embeddedConsoleUiSetting = core.uiSettings.get(_public.ENABLE_PERSISTENT_CONSOLE_UI_SETTING_ID);
    const embeddedConsoleAvailable = isConsoleUiEnabled && isEmbeddedConsoleEnabled && ((_core$application$cap = core.application.capabilities) === null || _core$application$cap === void 0 ? void 0 : (_core$application$cap2 = _core$application$cap.dev_tools) === null || _core$application$cap2 === void 0 ? void 0 : _core$application$cap2.show) === true && embeddedConsoleUiSetting;
    if (embeddedConsoleAvailable) {
      consoleStart.EmbeddableConsole = _props => {
        return (0, _embeddable.EmbeddableConsole)({
          core,
          usageCollection: deps.usageCollection,
          setDispatch: d => {
            this._embeddableConsole.setDispatch(d);
          },
          alternateView: this._embeddableConsole.alternateView,
          getConsoleHeight: this._embeddableConsole.getConsoleHeight.bind(this._embeddableConsole),
          setConsoleHeight: this._embeddableConsole.setConsoleHeight.bind(this._embeddableConsole)
        });
      };
      consoleStart.isEmbeddedConsoleAvailable = () => this._embeddableConsole.isEmbeddedConsoleAvailable();
      consoleStart.openEmbeddedConsole = content => this._embeddableConsole.openEmbeddedConsole(content);
      consoleStart.registerEmbeddedConsoleAlternateView = view => {
        this._embeddableConsole.registerAlternateView(view);
      };
    }
    return consoleStart;
  }
}
exports.ConsoleUIPlugin = ConsoleUIPlugin;