"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _immer = require("immer");
var _function = require("fp-ts/lib/function");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialResultValue = {
  data: null,
  type: 'unknown'
};
const initialValue = exports.initialValue = (0, _immer.produce)({
  requestInFlight: false,
  lastResult: initialResultValue
}, _function.identity);
const reducer = (state, action) => (0, _immer.produce)(state, draft => {
  if (action.type === 'sendRequest') {
    draft.requestInFlight = true;
    draft.lastResult = initialResultValue;
    return;
  }
  if (action.type === 'requestSuccess') {
    draft.requestInFlight = false;
    draft.lastResult = action.payload;
    return;
  }
  if (action.type === 'requestFail') {
    draft.requestInFlight = false;
    draft.lastResult = {
      ...initialResultValue,
      error: action.payload
    };
    return;
  }
});
exports.reducer = reducer;