"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _immer = require("immer");
var _function = require("fp-ts/lib/function");
var _embeddable_console = require("../../types/embeddable_console");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialValue = exports.initialValue = (0, _immer.produce)({
  view: _embeddable_console.EmbeddableConsoleView.Closed
}, _function.identity);
const reducer = (state, action) => (0, _immer.produce)(state, draft => {
  var _action$payload;
  switch (action.type) {
    case 'open':
      const newView = (_action$payload = action.payload) !== null && _action$payload !== void 0 && _action$payload.alternateView ? _embeddable_console.EmbeddableConsoleView.Alternate : _embeddable_console.EmbeddableConsoleView.Console;
      if (state.view !== newView) {
        var _action$payload2;
        draft.view = newView;
        draft.loadFromContent = (_action$payload2 = action.payload) === null || _action$payload2 === void 0 ? void 0 : _action$payload2.content;
        return draft;
      }
      break;
    case 'close':
      if (state.view !== _embeddable_console.EmbeddableConsoleView.Closed) {
        draft.view = _embeddable_console.EmbeddableConsoleView.Closed;
        draft.loadFromContent = undefined;
        return draft;
      }
      break;
  }
  return state;
});
exports.reducer = reducer;