"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _services = require("../services");
var _tracker = require("../services/tracker");
var _kb = require("../lib/kb");
var localStorageObjectClient = _interopRequireWildcard(require("../lib/local_storage_object_client"));
var _containers = require("./containers");
var _contexts = require("./contexts");
var _lib = require("./lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function renderApp({
  I18nContext,
  notifications,
  docLinkVersion,
  usageCollection,
  element,
  http,
  theme$,
  docLinks,
  autocompleteInfo,
  isMonacoEnabled
}) {
  const trackUiMetric = (0, _tracker.createUsageTracker)(usageCollection);
  trackUiMetric.load('opened_app');
  await (0, _kb.loadActiveApi)(http);
  const storage = (0, _services.createStorage)({
    engine: window.localStorage,
    prefix: 'sense:'
  });
  (0, _services.setStorage)(storage);
  const history = (0, _services.createHistory)({
    storage
  });
  const settings = (0, _services.createSettings)({
    storage
  });
  const objectStorageClient = localStorageObjectClient.create(storage);
  const api = (0, _lib.createApi)({
    http
  });
  const esHostService = (0, _lib.createEsHostService)({
    api
  });
  autocompleteInfo.mapping.setup(http, settings);
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.ServicesContextProvider, {
    value: {
      docLinkVersion,
      docLinks,
      services: {
        esHostService,
        storage,
        history,
        settings,
        notifications,
        trackUiMetric,
        objectStorageClient,
        http,
        autocompleteInfo
      },
      theme$,
      config: {
        isMonacoEnabled
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.RequestContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.EditorContextProvider, {
    settings: settings.toJSON()
  }, /*#__PURE__*/_react.default.createElement(_containers.Main, null)))))), element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
}