"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackSentRequests = exports.stringifyRequest = exports.replaceRequestVariables = exports.removeTrailingWhitespaces = exports.getCurlRequest = void 0;
var _es = require("../../../../lib/es");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const whitespacesRegex = /\s/;
const removeTrailingWhitespaces = url => {
  /*
   * This helper removes any trailing inline comments, for example
   * "_search // comment" -> "_search"
   * Ideally the parser removes those comments initially
   */
  return url.trim().split(whitespacesRegex)[0];
};
exports.removeTrailingWhitespaces = removeTrailingWhitespaces;
const stringifyRequest = parsedRequest => {
  var _parsedRequest$data;
  const url = removeTrailingWhitespaces(parsedRequest.url);
  const method = parsedRequest.method.toUpperCase();
  const data = (_parsedRequest$data = parsedRequest.data) === null || _parsedRequest$data === void 0 ? void 0 : _parsedRequest$data.map(parsedData => JSON.stringify(parsedData, null, 2));
  return {
    url,
    method,
    data: data !== null && data !== void 0 ? data : []
  };
};
exports.stringifyRequest = stringifyRequest;
const variableTemplateRegex = /\${(\w+)}/g;
const replaceVariables = (text, variables) => {
  if (variableTemplateRegex.test(text)) {
    text = text.replaceAll(variableTemplateRegex, (match, key) => {
      var _variable$value;
      const variable = variables.find(({
        name
      }) => name === key);
      return (_variable$value = variable === null || variable === void 0 ? void 0 : variable.value) !== null && _variable$value !== void 0 ? _variable$value : match;
    });
  }
  return text;
};
const replaceRequestVariables = ({
  method,
  url,
  data
}, variables) => {
  return {
    method,
    url: replaceVariables(url, variables),
    data: data.map(dataObject => replaceVariables(dataObject, variables))
  };
};
exports.replaceRequestVariables = replaceRequestVariables;
const getCurlRequest = ({
  method,
  url,
  data
}, elasticsearchBaseUrl) => {
  const curlUrl = (0, _es.constructUrl)(elasticsearchBaseUrl, url);
  let curlRequest = `curl -X${method} "${curlUrl}" -H "kbn-xsrf: reporting"`;
  if (data.length > 0) {
    curlRequest += ` -H "Content-Type: application/json" -d'\n`;
    curlRequest += data.join('\n');
    curlRequest += "'";
  }
  return curlRequest;
};
exports.getCurlRequest = getCurlRequest;
const trackSentRequests = (requests, trackUiMetric) => {
  requests.map(({
    method,
    url
  }) => {
    const eventName = `${method}_${url}`;
    trackUiMetric.count(eventName);
  });
};
exports.trackSentRequests = trackSentRequests;