"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonacoEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _i18n = require("@kbn/i18n");
var _components = require("../../../components");
var _contexts = require("../../../contexts");
var _use_set_initial_value = require("./use_set_initial_value");
var _monaco_editor_actions_provider = require("./monaco_editor_actions_provider");
var _use_setup_autocomplete_polling = require("./use_setup_autocomplete_polling");
var _use_setup_autosave = require("./use_setup_autosave");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MonacoEditor = ({
  initialTextValue
}) => {
  const {
    services: {
      notifications,
      esHostService,
      trackUiMetric,
      http,
      settings: settingsService,
      autocompleteInfo
    }
  } = (0, _contexts.useServicesContext)();
  const {
    toasts
  } = notifications;
  const {
    settings
  } = (0, _contexts.useEditorReadContext)();
  const dispatch = (0, _contexts.useRequestActionContext)();
  const actionsProvider = (0, _react.useRef)(null);
  const [editorActionsCss, setEditorActionsCss] = (0, _react.useState)({});
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    actionsProvider.current = new _monaco_editor_actions_provider.MonacoEditorActionsProvider(editor, setEditorActionsCss);
  }, []);
  const getCurlCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr;
    const curl = await ((_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.getCurl(esHostService.getHost()));
    return curl !== null && curl !== void 0 ? curl : '';
  }, [esHostService]);
  const sendRequestsCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr2;
    await ((_actionsProvider$curr2 = actionsProvider.current) === null || _actionsProvider$curr2 === void 0 ? void 0 : _actionsProvider$curr2.sendRequests(toasts, dispatch, trackUiMetric, http));
  }, [dispatch, http, toasts, trackUiMetric]);
  const [value, setValue] = (0, _react.useState)(initialTextValue);
  const setInitialValue = _use_set_initial_value.useSetInitialValue;
  (0, _react.useEffect)(() => {
    setInitialValue({
      initialTextValue,
      setValue,
      toasts
    });
  }, [initialTextValue, setInitialValue, toasts]);
  (0, _use_setup_autocomplete_polling.useSetupAutocompletePolling)({
    autocompleteInfo,
    settingsService
  });
  (0, _use_setup_autosave.useSetupAutosave)({
    value
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "conApp__editorActions",
    id: "ConAppEditorActions",
    gutterSize: "none",
    responsive: false,
    style: editorActionsCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('console.sendRequestButtonTooltip', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    onClick: sendRequestsCallback,
    "data-test-subj": "sendRequestButton",
    "aria-label": _i18n.i18n.translate('console.sendRequestButtonTooltip', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "play"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ConsoleMenu, {
    getCurl: getCurlCallback,
    getDocumentation: () => {
      return Promise.resolve(null);
    },
    autoIndent: () => {},
    notifications: notifications
  }))), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.CONSOLE_LANG_ID,
    value: value,
    onChange: setValue,
    fullWidth: true,
    accessibilityOverlayEnabled: settings.isAccessibilityOverlayEnabled,
    options: {
      fontSize: settings.fontSize,
      wordWrap: settings.wrapMode === true ? 'on' : 'off',
      theme: _monaco.CONSOLE_THEME_ID
    },
    editorDidMount: editorDidMountCallback
  }));
};
exports.MonacoEditor = MonacoEditor;