"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subscribeResizeChecker = subscribeResizeChecker;
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function subscribeResizeChecker(el, ...editors) {
  const checker = new _public.ResizeChecker(el);
  checker.on('resize', () => editors.forEach(e => {
    if (e.getCoreEditor) {
      e.getCoreEditor().resize();
    } else {
      e.resize();
    }
    if (e.updateActionsBar) {
      e.updateActionsBar();
    }
  }));
  return () => checker.destroy();
}