"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _ = require("..");
var _console_editor = require("./legacy/console_editor");
var _services = require("../../../services");
var _contexts = require("../../contexts");
var _monaco = require("./monaco");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const INITIAL_PANEL_WIDTH = 50;
const PANEL_MIN_WIDTH = '100px';
const Editor = exports.Editor = /*#__PURE__*/(0, _react.memo)(({
  loading,
  setEditorInstance
}) => {
  const {
    services: {
      storage
    },
    config: {
      isMonacoEnabled
    } = {}
  } = (0, _contexts.useServicesContext)();
  const {
    currentTextObject
  } = (0, _contexts.useEditorReadContext)();
  const {
    requestInFlight
  } = (0, _contexts.useRequestReadContext)();
  const [fetchingMappings, setFetchingMappings] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscription = (0, _services.getAutocompleteInfo)().mapping.isLoading$.subscribe(setFetchingMappings);
    return () => {
      subscription.unsubscribe();
    };
  }, []);
  const [firstPanelWidth, secondPanelWidth] = storage.get(_services.StorageKeys.WIDTH, [INITIAL_PANEL_WIDTH, INITIAL_PANEL_WIDTH]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const onPanelWidthChange = (0, _react.useCallback)((0, _lodash.debounce)(widths => {
    storage.set(_services.StorageKeys.WIDTH, widths);
  }, 300), []);
  if (!currentTextObject) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, requestInFlight || fetchingMappings ? /*#__PURE__*/_react.default.createElement("div", {
    className: "conApp__requestProgressBarContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })) : null, /*#__PURE__*/_react.default.createElement(_.PanelsContainer, {
    onPanelWidthChange: onPanelWidthChange,
    resizerClassName: "conApp__resizer"
  }, /*#__PURE__*/_react.default.createElement(_.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: firstPanelWidth
  }, loading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, null) : isMonacoEnabled ? /*#__PURE__*/_react.default.createElement(_monaco.MonacoEditor, {
    initialTextValue: currentTextObject.text
  }) : /*#__PURE__*/_react.default.createElement(_console_editor.Editor, {
    initialTextValue: currentTextObject.text,
    setEditorInstance: setEditorInstance
  })), /*#__PURE__*/_react.default.createElement(_.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: secondPanelWidth
  }, loading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, null) : isMonacoEnabled ? /*#__PURE__*/_react.default.createElement(_monaco.MonacoEditorOutput, null) : /*#__PURE__*/_react.default.createElement(_console_editor.EditorOutput, null))));
});