"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsVariablesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var utils = _interopRequireWildcard(require("./utils"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DevToolsVariablesFlyout = props => {
  const [variables, setVariables] = (0, _react.useState)(props.variables);
  const formId = (0, _eui.useGeneratedHtmlId)({
    prefix: '__console'
  });
  const addNewVariable = (0, _react.useCallback)(() => {
    setVariables(v => [...v, utils.generateEmptyVariableField()]);
  }, []);
  const deleteVariable = (0, _react.useCallback)(id => {
    const updatedVariables = utils.deleteVariable(variables, id);
    setVariables(updatedVariables);
  }, [variables]);
  const onSubmit = (0, _react.useCallback)(e => {
    e.preventDefault();
    props.onSaveVariables(variables.filter(({
      name,
      value
    }) => name.trim() && value));
  }, [props, variables]);
  const onChange = (0, _react.useCallback)((event, id) => {
    const {
      name,
      value
    } = event.target;
    const editedVariables = utils.editVariable(name, value, id, variables);
    setVariables(editedVariables);
  }, [variables]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('console.variablesPage.variablesTable.columns.variableHeader', {
      defaultMessage: 'Variable name'
    }),
    render: (name, {
      id
    }) => {
      const isInvalid = !utils.isValidVariableName(name);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        isInvalid: isInvalid,
        error: [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "console.variablesPage.variablesTable.variableInputError.validCharactersText",
          defaultMessage: "Only letters, numbers and underscores are allowed"
        })],
        fullWidth: true,
        css: {
          flexGrow: 1
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "variablesNameInput",
        name: "name",
        value: name,
        onChange: e => onChange(e, id),
        isInvalid: isInvalid,
        fullWidth: true,
        "aria-label": _i18n.i18n.translate('console.variablesPage.variablesTable.variableInput.ariaLabel', {
          defaultMessage: 'Variable name'
        })
      }));
    }
  }, {
    field: 'value',
    name: _i18n.i18n.translate('console.variablesPage.variablesTable.columns.valueHeader', {
      defaultMessage: 'Value'
    }),
    render: (value, {
      id
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "variablesValueInput",
      name: "value",
      onChange: e => onChange(e, id),
      value: value,
      "aria-label": _i18n.i18n.translate('console.variablesPage.variablesTable.valueInput.ariaLabel', {
        defaultMessage: 'Variable value'
      })
    })
  }, {
    field: 'id',
    name: '',
    width: '5%',
    render: id => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      "aria-label": "Delete",
      color: "danger",
      onClick: () => deleteVariable(id),
      "data-test-subj": "variablesRemoveButton"
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.pageTitle",
    defaultMessage: "Variables"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.descriptionText",
    defaultMessage: "Define variables and use them in your requests in the form of {variable}.",
    values: {
      variable: /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "console.variablesPage.descriptionText.variableNameText",
        defaultMessage: "{variableName}",
        values: {
          variableName: '${variableName}'
        }
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: formId,
    component: "form",
    onSubmit: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: variables,
    columns: columns
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "variablesAddButton",
    iconType: "plus",
    onClick: addNewVariable
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addButtonLabel",
    defaultMessage: "Add"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "variablesCancelButton",
    onClick: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "variablesSaveButton",
    type: "submit",
    form: formId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.saveButtonLabel",
    defaultMessage: "Save"
  }))))));
};
exports.DevToolsVariablesFlyout = DevToolsVariablesFlyout;