"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidVariableName = exports.generateEmptyVariableField = exports.editVariable = exports.deleteVariable = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const editVariable = (name, value, id, variables) => {
  const index = variables.findIndex(v => v.id === id);
  if (index === -1) {
    return variables;
  }
  return [...variables.slice(0, index), {
    ...variables[index],
    [name]: value
  }, ...variables.slice(index + 1)];
};
exports.editVariable = editVariable;
const deleteVariable = (variables, id) => {
  return variables.filter(v => v.id !== id);
};
exports.deleteVariable = deleteVariable;
const generateEmptyVariableField = () => ({
  id: (0, _uuid.v4)(),
  name: '',
  value: ''
});
exports.generateEmptyVariableField = generateEmptyVariableField;
const isValidVariableName = name => {
  /*
   * MUST avoid characters that get URL-encoded, because they'll result in unusable variable names.
   * Common variable names consist of letters, digits, and underscores and do not begin with a digit.
   * However, the ones beginning with a digit are still allowed here for backward compatibility.
   */
  return typeof name === 'string' && name.match(/^[a-zA-Z0-9_]+$/g) !== null;
};
exports.isValidVariableName = isValidVariableName;