"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splitKey = exports.getUnsplittableKey = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const splitKey = rawKey => {
  if (rawKey.startsWith('[') && rawKey.endsWith(']')) {
    return [rawKey.substring(1, rawKey.length - 1)];
  }
  return rawKey.split('.');
};
exports.splitKey = splitKey;
const getUnsplittableKey = rawKey => {
  if (rawKey.startsWith('[') && rawKey.endsWith(']')) {
    return rawKey.substring(1, rawKey.length - 1);
  }
  return undefined;
};
exports.getUnsplittableKey = getUnsplittableKey;