"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RawConfigService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _read_config = require("./read_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class RawConfigService {
  constructor(configFiles, configAdapter = rawConfig => rawConfig) {
    /**
     * The stream of configs read from the config file.
     *
     * This is the _raw_ config before any overrides are applied.
     */
    (0, _defineProperty2.default)(this, "rawConfigFromFile$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "config$", void 0);
    this.configFiles = configFiles;
    this.config$ = this.rawConfigFromFile$.pipe((0, _rxjs.map)(rawConfig => {
      if ((0, _lodash.isPlainObject)(rawConfig)) {
        // TODO Make config consistent, e.g. handle dots in keys
        return configAdapter((0, _lodash.cloneDeep)(rawConfig));
      }
      throw new Error(`the raw config must be an object, got [${(0, _typeDetect.default)(rawConfig)}]`);
    }));
  }

  /**
   * Read the initial Kibana config.
   */
  loadConfig() {
    this.rawConfigFromFile$.next((0, _read_config.getConfigFromFiles)(this.configFiles));
  }
  stop() {
    this.rawConfigFromFile$.complete();
  }

  /**
   * Re-read the Kibana config.
   */
  reloadConfig() {
    this.loadConfig();
  }
  getConfig$() {
    return this.config$;
  }
}
exports.RawConfigService = RawConfigService;