"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddStop = AddStop;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _color_mapping = require("../../state/color_mapping");
var _ui = require("../../state/ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function AddStop({
  colorMode,
  currentPalette,
  at
}) {
  const euiTheme = (0, _eui.useEuiTheme)();
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('coloring.colorMapping.container.addGradientStopButtonLabel', {
      defaultMessage: 'Add gradient stop'
    })
  }, /*#__PURE__*/_react.default.createElement("button", {
    id: "lnsColorMappingGradientAddButton",
    css: (0, _react2.css)`
            position: relative;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            padding: 0;
            ${(0, _eui.euiFocusRing)(euiTheme)};
            opacity: 0;
            ${_eui.euiCanAnimate} {
              transition: opacity ${euiTheme.euiTheme.animation.fast} ease-in;
            }
          `,
    onClick: () => {
      dispatch((0, _color_mapping.addGradientColorStep)({
        color: {
          type: 'categorical',
          colorIndex: colorMode.steps.length,
          paletteId: currentPalette.id
        },
        at
      }));
      dispatch((0, _ui.colorPickerVisibility)({
        index: at,
        type: 'gradient',
        visible: true
      }));
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              width: 16px;
              height: 16px;
              border-radius: 50%;
              background-color: ${euiTheme.euiTheme.colors.emptyShade};
              transform-origin: center;
              transition: transform ${euiTheme.euiTheme.animation.fast} ease-in;
              &:hover {
                transform: scale(1.2);
              }
              ${(0, _eui.euiShadowSmall)(euiTheme)}
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plus",
    height: 16,
    width: 16,
    css: (0, _react2.css)`
                position: absolute;
                top: 0;
                left: 0;
                width: 16px;
                height: 16px;
              `,
    color: euiTheme.euiTheme.colors.text
  })))));
}