"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssignmentColor = getAssignmentColor;
exports.getColor = getColor;
exports.getColorFactory = getColorFactory;
exports.getGradientColorScale = getGradientColorScale;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _lodash = require("lodash");
var _color_math = require("./color_math");
var _palettes = require("../palettes");
var _rule_matching = require("./rule_matching");
var _default_color_mapping = require("../config/default_color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getAssignmentColor(colorMode, color, getPaletteFn, isDarkMode, index, total) {
  switch (color.type) {
    case 'colorCode':
    case 'categorical':
    case 'loop':
      return getColor(color, getPaletteFn, isDarkMode);
    case 'gradient':
      {
        if (colorMode.type === 'categorical') {
          return 'red';
        }
        const colorScale = getGradientColorScale(colorMode, getPaletteFn, isDarkMode);
        return total === 0 ? 'red' : total === 1 ? colorScale(0) : colorScale(index / (total - 1));
      }
  }
}
function getColor(color, getPaletteFn, isDarkMode) {
  return color.type === 'colorCode' ? color.colorCode : (0, _color_math.getValidColor)(getPaletteFn(color.paletteId).getColor(color.colorIndex, isDarkMode, true)).hex();
}
function getColorFactory({
  assignments,
  specialAssignments,
  colorMode,
  paletteId
}, getPaletteFn, isDarkMode, data) {
  // find auto-assigned colors
  const autoByOrderAssignments = data.type === 'categories' ? assignments.filter(a => {
    return a.rule.type === 'auto' || a.rule.type === 'matchExactly' && a.rule.values.length === 0;
  }) : [];

  // find all categories that doesn't match with an assignment
  const notAssignedCategories = data.type === 'categories' ? data.categories.filter(category => {
    return !assignments.some(({
      rule
    }) => (0, _rule_matching.ruleMatch)(rule, category));
  }) : [];
  const lastCategorical = (0, _lodash.findLast)(assignments, d => {
    return d.color.type === 'categorical';
  });
  const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
  return category => {
    if (typeof category === 'string' || Array.isArray(category)) {
      const nonAssignedCategoryIndex = notAssignedCategories.indexOf(category);

      // this category is not assigned to a specific color
      if (nonAssignedCategoryIndex > -1) {
        // if the category order is within current number of auto-assigned items pick the defined color
        if (nonAssignedCategoryIndex < autoByOrderAssignments.length) {
          const autoAssignmentIndex = assignments.findIndex(d => d === autoByOrderAssignments[nonAssignedCategoryIndex]);
          return getAssignmentColor(colorMode, autoByOrderAssignments[nonAssignedCategoryIndex].color, getPaletteFn, isDarkMode, autoAssignmentIndex, assignments.length);
        }
        const totalColorsIfGradient = assignments.length || notAssignedCategories.length;
        const indexIfGradient = (nonAssignedCategoryIndex - autoByOrderAssignments.length) % totalColorsIfGradient;

        // if no auto-assign color rule/color is available then use the color looping palette
        return getAssignmentColor(colorMode,
        // TODO: the specialAssignment[0] position is arbitrary, we should fix it better
        specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX].color.type === 'loop' ? colorMode.type === 'gradient' ? {
          type: 'gradient'
        } : {
          type: 'loop',
          // those are applied here and depends on the current non-assigned category - auto-assignment list
          colorIndex: nonAssignedCategoryIndex - autoByOrderAssignments.length + nextCategoricalIndex,
          paletteId
        } : specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX].color, getPaletteFn, isDarkMode, indexIfGradient, totalColorsIfGradient);
      }
    }
    // find the assignment where the category matches the rule
    const matchingAssignmentIndex = assignments.findIndex(({
      rule
    }) => {
      return (0, _rule_matching.ruleMatch)(rule, category);
    });
    if (matchingAssignmentIndex > -1) {
      const assignment = assignments[matchingAssignmentIndex];
      return getAssignmentColor(colorMode, assignment.color, getPaletteFn, isDarkMode, matchingAssignmentIndex, assignments.length);
    }
    return getColor({
      type: 'categorical',
      paletteId: _palettes.NeutralPalette.id,
      colorIndex: _default_color_mapping.DEFAULT_NEUTRAL_PALETTE_INDEX
    }, getPaletteFn, isDarkMode);
  };
}
function getGradientColorScale(colorMode, getPaletteFn, isDarkMode) {
  const steps = colorMode.steps.length === 1 ? [getColor(colorMode.steps[0], getPaletteFn, isDarkMode), (0, _color_math.combineColors)((0, _color_math.changeAlpha)(getColor(colorMode.steps[0], getPaletteFn, isDarkMode), 0.3), isDarkMode ? 'black' : 'white')] : colorMode.steps.map(d => getColor(d, getPaletteFn, isDarkMode));
  steps.sort(() => colorMode.sort === 'asc' ? -1 : 1);
  const scale = _chromaJs.default.scale(steps).mode('lab');
  return value => scale(value).hex();
}