"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVulnerabilitiesStatisticsQuery = exports.getVulnerabilitiesStatistics = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVulnerabilitiesStatisticsQuery = () => ({
  size: 0,
  query: {
    match_all: {}
  },
  index: _constants.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS,
  aggs: {
    critical: {
      filter: {
        term: {
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.CRITICAL
        }
      }
    },
    high: {
      filter: {
        term: {
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.HIGH
        }
      }
    },
    medium: {
      filter: {
        term: {
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.MEDIUM
        }
      }
    },
    resources_scanned: {
      cardinality: {
        field: 'resource.id'
      }
    },
    cloud_accounts: {
      cardinality: {
        field: 'cloud.account.id'
      }
    }
  }
});
exports.getVulnerabilitiesStatisticsQuery = getVulnerabilitiesStatisticsQuery;
const getVulnerabilitiesStatistics = async esClient => {
  var _queryResult$aggregat, _queryResult$aggregat2, _queryResult$aggregat3, _queryResult$aggregat4, _queryResult$aggregat5;
  const queryResult = await esClient.search(getVulnerabilitiesStatisticsQuery());
  return {
    criticalCount: (_queryResult$aggregat = queryResult.aggregations) === null || _queryResult$aggregat === void 0 ? void 0 : _queryResult$aggregat.critical.doc_count,
    highCount: (_queryResult$aggregat2 = queryResult.aggregations) === null || _queryResult$aggregat2 === void 0 ? void 0 : _queryResult$aggregat2.high.doc_count,
    mediumCount: (_queryResult$aggregat3 = queryResult.aggregations) === null || _queryResult$aggregat3 === void 0 ? void 0 : _queryResult$aggregat3.medium.doc_count,
    resourcesScanned: (_queryResult$aggregat4 = queryResult.aggregations) === null || _queryResult$aggregat4 === void 0 ? void 0 : _queryResult$aggregat4.resources_scanned.value,
    cloudAccounts: (_queryResult$aggregat5 = queryResult.aggregations) === null || _queryResult$aggregat5 === void 0 ? void 0 : _queryResult$aggregat5.cloud_accounts.value
  };
};
exports.getVulnerabilitiesStatistics = getVulnerabilitiesStatistics;