"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMutedRulesFilterQuery = exports.getCspBenchmarkRulesStatesHandler = exports.createCspSettingObject = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/constants");
var _rules_states = require("../../../../common/utils/rules_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCspSettingObject = async soClient => {
  return soClient.create(_constants.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE, {
    rules: {}
  }, {
    id: _constants.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_ID
  });
};
exports.createCspSettingObject = createCspSettingObject;
const getCspBenchmarkRulesStatesHandler = async encryptedSoClient => {
  try {
    const getSoResponse = await encryptedSoClient.get(_constants.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE, _constants.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_ID);
    return getSoResponse.attributes.rules;
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    if (error.statusCode === 404) {
      const newCspSettings = await createCspSettingObject(encryptedSoClient);
      return newCspSettings.attributes.rules;
    }
    throw new Error(`An error occurred while trying to fetch csp settings: ${error.message}, ${error.statusCode}`);
  }
};
exports.getCspBenchmarkRulesStatesHandler = getCspBenchmarkRulesStatesHandler;
const getMutedRulesFilterQuery = async encryptedSoClient => {
  const rulesStates = await getCspBenchmarkRulesStatesHandler(encryptedSoClient);
  const mutedRulesFilterQuery = (0, _rules_states.buildMutedRulesFilter)(rulesStates);
  return mutedRulesFilterQuery;
};
exports.getMutedRulesFilterQuery = getMutedRulesFilterQuery;