"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.latestVulnerabilitiesTransform = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const latestVulnerabilitiesTransform = exports.latestVulnerabilitiesTransform = {
  transform_id: 'cloud_security_posture.vulnerabilities_latest-default-8.8.0',
  description: 'Defines vulnerabilities transformation to view only the latest vulnerability per resource',
  source: {
    index: _constants.VULNERABILITIES_INDEX_PATTERN
  },
  dest: {
    index: _constants.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS
  },
  frequency: '5m',
  sync: {
    time: {
      field: 'event.ingested',
      delay: '60s'
    }
  },
  retention_policy: {
    time: {
      field: '@timestamp',
      max_age: _constants.LATEST_VULNERABILITIES_RETENTION_POLICY
    }
  },
  latest: {
    sort: '@timestamp',
    unique_key: ['vulnerability.id', 'resource.id', 'package.name', 'package.version']
  },
  settings: {
    unattended: true
  },
  _meta: {
    package: {
      name: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME
    },
    managed_by: 'cloud_security_posture',
    managed: true
  }
};