"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestVulnerabilities = exports.getVulnerabilitiesQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _ioTs = require("io-ts");
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _show_error_toast = require("../../../common/utils/show_error_toast");
var _constants3 = require("../constants");
var _custom_sort_script = require("../utils/custom_sort_script");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMultiFieldsSort = sort => {
  return sort.map(([id, direction]) => {
    if (id === _constants3.VULNERABILITY_FIELDS.PACKAGE_NAME) {
      return (0, _custom_sort_script.getCaseInsensitiveSortScript)(id, direction);
    }
    return {
      [id]: direction
    };
  });
};
const getVulnerabilitiesQuery = ({
  query,
  sort
}, pageParam) => {
  var _query$bool$filter, _query$bool;
  return {
    index: _constants2.LATEST_VULNERABILITIES_INDEX_PATTERN,
    sort: getMultiFieldsSort(sort),
    size: _constants.MAX_FINDINGS_TO_LOAD,
    query: {
      ...query,
      bool: {
        ...(query === null || query === void 0 ? void 0 : query.bool),
        filter: [...((_query$bool$filter = query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) !== null && _query$bool$filter !== void 0 ? _query$bool$filter : []), {
          range: {
            '@timestamp': {
              gte: `now-${_constants2.LATEST_VULNERABILITIES_RETENTION_POLICY}`,
              lte: 'now'
            }
          }
        }]
      }
    },
    ...(pageParam ? {
      from: pageParam
    } : {})
  };
};
exports.getVulnerabilitiesQuery = getVulnerabilitiesQuery;
const useLatestVulnerabilities = options => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  /**
   * We're using useInfiniteQuery in this case to allow the user to fetch more data (if available and up to 10k)
   * useInfiniteQuery differs from useQuery because it accumulates and caches a chunk of data from the previous fetches into an array
   * it uses the getNextPageParam to know if there are more pages to load and retrieve the position of
   * the last loaded record to be used as a from parameter to fetch the next chunk of data.
   */
  return (0, _reactQuery.useInfiniteQuery)([_constants2.LATEST_VULNERABILITIES_INDEX_PATTERN, options], async ({
    pageParam
  }) => {
    const {
      rawResponse: {
        hits
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getVulnerabilitiesQuery(options, pageParam)
    }));
    return {
      page: hits.hits.map(hit => (0, _discoverUtils.buildDataTableRecord)(hit)),
      total: _ioTs.number.is(hits.total) ? hits.total : 0
    };
  }, {
    staleTime: 5000,
    keepPreviousData: true,
    enabled: options.enabled,
    onError: err => (0, _show_error_toast.showErrorToast)(toasts, err),
    getNextPageParam: (lastPage, allPages) => {
      if (lastPage.page.length < options.pageSize) {
        return undefined;
      }
      return allPages.length * options.pageSize;
    }
  });
};
exports.useLatestVulnerabilities = useLatestVulnerabilities;