"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspGetRulesStates = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY_V1 = 'csp_rules_states_v1';
const useCspGetRulesStates = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([QUERY_KEY_V1], () => http.get(_constants.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH, {
    version: '1'
  }), {
    keepPreviousData: true
  });
};
exports.useCspGetRulesStates = useCspGetRulesStates;