"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableHeader = exports.RULE_NUMBER_FILTER = exports.RULES_SELECT_ALL_RULES = exports.RULES_ENABLED_FILTER = exports.RULES_DISABLED_FILTER = exports.RULES_CLEAR_ALL_RULES_SELECTION = exports.RULES_BULK_ACTION_OPTION_ENABLE = exports.RULES_BULK_ACTION_OPTION_DISABLE = exports.RULES_BULK_ACTION_BUTTON = exports.CIS_SECTION_FILTER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _use_kibana = require("../../common/hooks/use_kibana");
var _detection_rules = require("../../../common/utils/detection_rules");
var _change_csp_rule_state = require("./change_csp_rule_state");
var _multi_select_filter = require("../../common/component/multi_select_filter");
var _take_action = require("../../components/take_action");
var _use_fetch_detection_rules_by_tags = require("../../common/api/use_fetch_detection_rules_by_tags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_BULK_ACTION_BUTTON = exports.RULES_BULK_ACTION_BUTTON = 'bulk-action-button';
const RULES_BULK_ACTION_OPTION_ENABLE = exports.RULES_BULK_ACTION_OPTION_ENABLE = 'bulk-action-option-enable';
const RULES_BULK_ACTION_OPTION_DISABLE = exports.RULES_BULK_ACTION_OPTION_DISABLE = 'bulk-action-option-disable';
const RULES_SELECT_ALL_RULES = exports.RULES_SELECT_ALL_RULES = 'select-all-rules-button';
const RULES_CLEAR_ALL_RULES_SELECTION = exports.RULES_CLEAR_ALL_RULES_SELECTION = 'clear-rules-selection-button';
const RULES_DISABLED_FILTER = exports.RULES_DISABLED_FILTER = 'rules-disabled-filter';
const RULES_ENABLED_FILTER = exports.RULES_ENABLED_FILTER = 'rules-enabled-filter';
const CIS_SECTION_FILTER = exports.CIS_SECTION_FILTER = 'cis-section-filter';
const RULE_NUMBER_FILTER = exports.RULE_NUMBER_FILTER = 'rule-number-filter';
const RulesTableHeader = ({
  search,
  searchValue,
  isSearching,
  totalRulesCount,
  pageSize,
  onSectionChange,
  onRuleNumberChange,
  sectionSelectOptions,
  ruleNumberSelectOptions,
  selectedRules,
  refetchRulesStates,
  setEnabledDisabledItemsFilter,
  enabledDisabledItemsFilterState,
  setSelectAllRules,
  setSelectedRules
}) => {
  const [selectedSection, setSelectedSection] = (0, _react.useState)([]);
  const [selectedRuleNumber, setSelectedRuleNumber] = (0, _react.useState)([]);
  const sectionOptions = sectionSelectOptions.map(option => ({
    key: option,
    label: option
  }));
  const ruleNumberOptions = ruleNumberSelectOptions.map(option => ({
    key: option,
    label: option
  }));
  const toggleEnabledRulesFilter = () => {
    if (enabledDisabledItemsFilterState === 'enabled') setEnabledDisabledItemsFilter('no-filter');else setEnabledDisabledItemsFilter('enabled');
  };
  const toggleDisabledRulesFilter = () => {
    if (enabledDisabledItemsFilterState === 'disabled') setEnabledDisabledItemsFilter('no-filter');else setEnabledDisabledItemsFilter('disabled');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(SearchField, {
    isSearching: isSearching,
    searchValue: searchValue,
    search: search
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                min-width: 160px;
              `
  }, /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: _i18n.i18n.translate('xpack.csp.rules.rulesTableHeader.sectionSelectPlaceholder', {
      defaultMessage: 'CIS Section'
    }),
    id: 'cis-section-multi-select-filter',
    onChange: section => {
      setSelectedSection([...(section === null || section === void 0 ? void 0 : section.selectedOptionKeys)]);
      onSectionChange(section !== null && section !== void 0 && section.selectedOptionKeys ? section === null || section === void 0 ? void 0 : section.selectedOptionKeys : undefined);
    },
    options: sectionOptions,
    selectedOptionKeys: selectedSection
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                min-width: 160px;
              `
  }, /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: _i18n.i18n.translate('xpack.csp.rules.rulesTableHeader.ruleNumberSelectPlaceholder', {
      defaultMessage: 'Rule Number'
    }),
    id: 'rule-number-multi-select-filter',
    onChange: ruleNumber => {
      setSelectedRuleNumber([...(ruleNumber === null || ruleNumber === void 0 ? void 0 : ruleNumber.selectedOptionKeys)]);
      onRuleNumberChange(ruleNumber !== null && ruleNumber !== void 0 && ruleNumber.selectedOptionKeys ? ruleNumber === null || ruleNumber === void 0 ? void 0 : ruleNumber.selectedOptionKeys : undefined);
    },
    options: ruleNumberOptions,
    selectedOptionKeys: selectedRuleNumber
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                min-width: 220px;
              `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    hasActiveFilters: enabledDisabledItemsFilterState === 'enabled',
    onClick: toggleEnabledRulesFilter,
    "data-test-subj": RULES_ENABLED_FILTER
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.enabledRuleFilterButton",
    defaultMessage: "Enabled rules"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: enabledDisabledItemsFilterState === 'disabled',
    onClick: toggleDisabledRulesFilter,
    "data-test-subj": RULES_DISABLED_FILTER
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.disabledRuleFilterButton",
    defaultMessage: "Disabled rules"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CurrentPageOfTotal, {
    pageSize: pageSize,
    total: totalRulesCount,
    selectedRules: selectedRules,
    refetchRulesStates: refetchRulesStates,
    setSelectAllRules: setSelectAllRules,
    setSelectedRules: setSelectedRules
  })));
};
exports.RulesTableHeader = RulesTableHeader;
const SEARCH_DEBOUNCE_MS = 300;
const SearchField = ({
  search,
  isSearching,
  searchValue
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)(searchValue);
  (0, _useDebounce.default)(() => search(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    isLoading: isSearching,
    placeholder: _i18n.i18n.translate('xpack.csp.rules.rulesTable.searchPlaceholder', {
      defaultMessage: 'Search by Rule Name'
    }),
    value: localValue,
    onChange: e => setLocalValue(e.target.value),
    style: {
      minWidth: 150
    },
    fullWidth: true
  })));
};
const CurrentPageOfTotal = ({
  pageSize,
  total,
  selectedRules,
  refetchRulesStates,
  setSelectAllRules,
  setSelectedRules
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverClick = () => {
    setIsPopoverOpen(e => !e);
  };
  const {
    data: rulesData
  } = (0, _use_fetch_detection_rules_by_tags.useFetchDetectionRulesByTags)((0, _detection_rules.getFindingsDetectionRuleSearchTagsFromArrayOfRules)(selectedRules.map(rule => rule.metadata)), {
    match: 'any'
  });
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const postRequestChangeRulesState = (0, _change_csp_rule_state.useChangeCspRuleState)();
  const changeRulesState = async state => {
    const bulkSelectedRules = selectedRules.map(e => ({
      benchmark_id: e === null || e === void 0 ? void 0 : e.metadata.benchmark.id,
      benchmark_version: e === null || e === void 0 ? void 0 : e.metadata.benchmark.version,
      rule_number: e === null || e === void 0 ? void 0 : e.metadata.benchmark.rule_number,
      rule_id: e === null || e === void 0 ? void 0 : e.metadata.id
    }));
    // Only do the API Call IF there are no undefined value for rule number in the selected rules
    if (!bulkSelectedRules.some(rule => rule.rule_number === undefined)) {
      await postRequestChangeRulesState(state, bulkSelectedRules);
      await refetchRulesStates();
      await setIsPopoverOpen(false);
      await (0, _take_action.showChangeBenchmarkRuleStatesSuccessToast)(notifications, state !== 'mute', {
        numberOfRules: bulkSelectedRules.length,
        numberOfDetectionRules: (rulesData === null || rulesData === void 0 ? void 0 : rulesData.total) || 0
      });
    }
  };
  const changeCspRuleStateMute = async () => {
    await changeRulesState('mute');
    setSelectedRules([]);
  };
  const changeCspRuleStateUnmute = async () => {
    await changeRulesState('unmute');
    setSelectedRules([]);
  };
  const areAllSelectedRulesMuted = selectedRules.every(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'muted');
  const areAllSelectedRulesUnmuted = selectedRules.every(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'unmuted');
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onPopoverClick,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    css: (0, _react2.css)`
        padding-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
      `,
    "data-test-subj": RULES_BULK_ACTION_BUTTON
  }, "Bulk actions");
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: selectedRules.length === 0 || areAllSelectedRulesUnmuted,
    onClick: changeCspRuleStateUnmute,
    "data-test-subj": RULES_BULK_ACTION_OPTION_ENABLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: "disabled"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.optionEnable",
    defaultMessage: "Enable"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: selectedRules.length === 0 || areAllSelectedRulesMuted,
    onClick: changeCspRuleStateMute,
    "data-test-subj": RULES_BULK_ACTION_OPTION_DISABLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.optionDisable",
    defaultMessage: "Disable"
  })))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "left",
    color: "subdued",
    style: {
      marginLeft: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.showingPageOfTotalLabel",
    defaultMessage: "Showing {pageSize} of {total, plural, one {# rule} other {# rules}} \\u2000|\\u2000 Selected {selectedRulesAmount, plural, one {# rule} other {# rules}}",
    values: {
      pageSize,
      total,
      selectedRulesAmount: selectedRules.length || 0
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, selectedRules.length !== total ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: setSelectAllRules,
    size: "xs",
    iconType: "pagesSelect",
    css: (0, _react2.css)`
                padding-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
              `,
    "data-test-subj": RULES_SELECT_ALL_RULES
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.selectAllRulesOption",
    defaultMessage: "Select All {total, plural, one {# rule} other {# rules}}",
    values: {
      total
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setSelectedRules([]),
    size: "xs",
    iconType: "cross",
    css: (0, _react2.css)`
                padding-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
              `,
    "data-test-subj": RULES_CLEAR_ALL_RULES_SELECTION
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.clearSelectionOption",
    defaultMessage: "Clear selection"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "downLeft",
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    style: {
      minWidth: 240
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "left",
    color: "subdued",
    style: {
      marginLeft: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.bulkActionsOptionTitle",
    defaultMessage: "Options"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    css: (0, _react2.css)`
                mid-width: 540px;
              `
  })))));
};