"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemediationList = exports.OverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _helpers = require("../../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _use_latest_findings_data_view = require("../../../common/api/use_latest_findings_data_view");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _findings_flyout = require("./findings_flyout");
var _findings_detection_rule_counter = require("./findings_detection_rule_counter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDetailsList = (data, ruleFlyoutLink, discoverIndexLink) => [{
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleNameTitle', {
    defaultMessage: 'Rule Name'
  }),
  description: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleNameTooltip', {
      defaultMessage: 'Manage Rule'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: ruleFlyoutLink
  }, data.rule.name))
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.alertsTitle', {
    defaultMessage: 'Alerts'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_detection_rule_counter.FindingsDetectionRuleCounter, {
    finding: data
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleTagsTitle', {
    defaultMessage: 'Rule Tags'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.rule.tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag
  }, tag)))
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.evaluatedAtTitle', {
    defaultMessage: 'Evaluated at'
  }),
  description: (0, _moment.default)(data['@timestamp']).format(_constants.CSP_MOMENT_FORMAT)
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.resourceIdTitle', {
    defaultMessage: 'Resource ID'
  }),
  description: data.resource.id
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.resourceNameTitle', {
    defaultMessage: 'Resource Name'
  }),
  description: data.resource.name
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.frameworkSourcesTitle', {
    defaultMessage: 'Framework Sources'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CisKubernetesIcons, {
    benchmarkId: data.rule.benchmark.id,
    benchmarkName: data.rule.benchmark.name
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.cisSectionTitle', {
    defaultMessage: 'CIS Section'
  }),
  description: data.rule.section
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.indexTitle', {
    defaultMessage: 'Index'
  }),
  description: discoverIndexLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: discoverIndexLink
  }, _constants2.LATEST_FINDINGS_INDEX_DEFAULT_NS) : _constants2.LATEST_FINDINGS_INDEX_DEFAULT_NS
}];
const getRemediationList = rule => [{
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.remediation)
}, ...(rule.impact ? [{
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.impactTitle', {
    defaultMessage: 'Impact'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.impact)
}] : []), ...(rule.default_value ? [{
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.defaultValueTitle', {
    defaultMessage: 'Default Value'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.default_value)
}] : []), {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.rationaleTitle', {
    defaultMessage: 'Rationale'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.rationale)
}];
exports.getRemediationList = getRemediationList;
const getEvidenceList = ({
  result
}) => [{
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsFlyout.overviewTab.evidenceDescription",
    defaultMessage: "The specific resource metadata that was evaluated to generate this posture finding"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_findings_flyout.CodeBlock, {
    language: "json"
  }, JSON.stringify(result.evidence, null, 2)))
}].filter(_helpers.truthy);
const OverviewTab = ({
  data,
  ruleFlyoutLink
}) => {
  var _latestFindingsDataVi2;
  const {
    discover
  } = (0, _use_kibana.useKibana)().services;
  const latestFindingsDataView = (0, _use_latest_findings_data_view.useLatestFindingsDataView)(_constants2.LATEST_FINDINGS_INDEX_PATTERN);
  const discoverIndexLink = (0, _react.useMemo)(() => {
    var _discover$locator, _latestFindingsDataVi;
    return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl({
      indexPatternId: (_latestFindingsDataVi = latestFindingsDataView.data) === null || _latestFindingsDataVi === void 0 ? void 0 : _latestFindingsDataVi.id
    });
  }, [discover.locator, (_latestFindingsDataVi2 = latestFindingsDataView.data) === null || _latestFindingsDataVi2 === void 0 ? void 0 : _latestFindingsDataVi2.id]);
  const hasEvidence = !(0, _lodash.isEmpty)(data.result.evidence);
  const accordions = (0, _react.useMemo)(() => [{
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.detailsTitle', {
      defaultMessage: 'Details'
    }),
    id: 'detailsAccordion',
    listItems: getDetailsList(data, ruleFlyoutLink, discoverIndexLink)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.remediationTitle', {
      defaultMessage: 'Remediation'
    }),
    id: 'remediationAccordion',
    listItems: getRemediationList(data.rule)
  }, _constants2.INTERNAL_FEATURE_FLAGS.showFindingFlyoutEvidence && hasEvidence && {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.evidenceSourcesTitle', {
      defaultMessage: 'Evidence'
    }),
    id: 'evidenceAccordion',
    listItems: getEvidenceList(data)
  }].filter(_helpers.truthy), [data, discoverIndexLink, hasEvidence, ruleFlyoutLink]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordions.map(accordion => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: accordion.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordion.id,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, accordion.title)),
    arrowDisplay: "left",
    initialIsOpen: accordion.initialIsOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: accordion.listItems
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
};
exports.OverviewTab = OverviewTab;