"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupTechnology = void 0;
var _react = require("react");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetupTechnology = ({
  input,
  agentPolicy,
  agentlessPolicy,
  handleSetupTechnologyChange,
  isEditPage
}) => {
  const isCspmAws = input.type === _constants.CLOUDBEAT_AWS;
  const isCspmGcp = input.type === _constants.CLOUDBEAT_GCP;
  const isCspmAzure = input.type === _constants.CLOUDBEAT_AZURE;
  const isAgentlessSupportedForCloudProvider = isCspmAws || isCspmGcp || isCspmAzure;
  const isAgentlessAvailable = Boolean(isAgentlessSupportedForCloudProvider && agentlessPolicy);
  const agentPolicyId = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id;
  const agentlessPolicyId = agentlessPolicy === null || agentlessPolicy === void 0 ? void 0 : agentlessPolicy.id;
  const [setupTechnology, setSetupTechnology] = (0, _react.useState)(() => {
    if (isEditPage && agentPolicyId === _public.SetupTechnology.AGENTLESS) {
      return _public.SetupTechnology.AGENTLESS;
    }
    return _public.SetupTechnology.AGENT_BASED;
  });
  (0, _react.useEffect)(() => {
    if (isEditPage) {
      return;
    }
    if (agentPolicyId && agentPolicyId !== agentlessPolicyId) {
      /*
        handle case when agent policy is coming from outside,
        e.g. from the get param or when coming to integration from a specific agent policy
      */
      setSetupTechnology(_public.SetupTechnology.AGENT_BASED);
    } else if (isAgentlessAvailable) {
      /*
        preselecting agentless when available
        and resetting to agent-based when switching to another integration type, which doesn't support agentless
      */
      setSetupTechnology(_public.SetupTechnology.AGENTLESS);
    } else {
      setSetupTechnology(_public.SetupTechnology.AGENT_BASED);
    }
  }, [agentPolicyId, agentlessPolicyId, isAgentlessAvailable, isEditPage]);
  (0, _react.useEffect)(() => {
    if (isEditPage) {
      return;
    }
    if (handleSetupTechnologyChange) {
      handleSetupTechnologyChange(setupTechnology);
    }
  }, [handleSetupTechnologyChange, isEditPage, setupTechnology]);
  return {
    isAgentlessAvailable,
    setupTechnology,
    setSetupTechnology
  };
};
exports.useSetupTechnology = useSetupTechnology;