"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/navigation/constants");
var _get_aws_credentials_form_options = require("./get_aws_credentials_form_options");
var _utils = require("../utils");
var _aws_input_var_fields = require("./aws_input_var_fields");
var _aws_credentials_form = require("./aws_credentials_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AwsCredentialsFormAgentless = ({
  input,
  newPolicy,
  packageInfo,
  updatePolicy
}) => {
  const awsCredentialsType = (0, _utils.getAwsCredentialsType)(input) || _get_aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE;
  const options = (0, _get_aws_credentials_form_options.getAwsCredentialsFormOptions)();
  const group = options[awsCredentialsType];
  const fields = (0, _get_aws_credentials_form_options.getInputVarsFields)(input, group.fields);
  const integrationLink = _constants.cspIntegrationDocsNavigation.cspm.getStartedPath;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AWSSetupInfoContent, {
    info: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContentAgentless",
      defaultMessage: "Utilize AWS Access Keys to set up and deploy CSPM for assessing your AWS environment's security posture. Refer to our {gettingStartedLink} guide for details.",
      values: {
        gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: integrationLink,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContentLink",
          defaultMessage: "Getting Started"
        }))
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AwsCredentialTypeSelector, {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.awsCredentialTypeSelectorLabelAgentless', {
      defaultMessage: 'Preferred method'
    }),
    type: awsCredentialsType,
    options: (0, _get_aws_credentials_form_options.getAwsCredentialsFormAgentlessOptions)(),
    onChange: optionId => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: integrationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_aws_input_var_fields.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    }
  }));
};
exports.AwsCredentialsFormAgentless = AwsCredentialsFormAgentless;