"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionRuleCounter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _useSessionStorage = _interopRequireDefault(require("react-use/lib/useSessionStorage"));
var _reactQuery = require("@tanstack/react-query");
var _use_fetch_detection_rules_alerts_status = require("../common/api/use_fetch_detection_rules_alerts_status");
var _use_fetch_detection_rules_by_tags = require("../common/api/use_fetch_detection_rules_by_tags");
var _use_kibana = require("../common/hooks/use_kibana");
var _take_action = require("./take_action");
var _constants = require("../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_PAGE_PATH = '/rules/management';
const ALERTS_PAGE_PATH = '/alerts';
const RULES_TABLE_SESSION_STORAGE_KEY = 'securitySolution.rulesTable';
const DetectionRuleCounter = ({
  tags,
  createRuleFn
}) => {
  const {
    data: rulesData,
    isLoading: ruleIsLoading
  } = (0, _use_fetch_detection_rules_by_tags.useFetchDetectionRulesByTags)(tags);
  const {
    data: alertsData,
    isLoading: alertsIsLoading
  } = (0, _use_fetch_detection_rules_alerts_status.useFetchDetectionRulesAlertsStatus)(tags);
  const [isCreateRuleLoading, setIsCreateRuleLoading] = (0, _react.useState)(false);
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const [, setRulesTable] = (0, _useSessionStorage.default)(RULES_TABLE_SESSION_STORAGE_KEY);
  const rulePageNavigation = (0, _react.useCallback)(async () => {
    await setRulesTable({
      tags
    });
    history.push({
      pathname: RULES_PAGE_PATH
    });
  }, [history, setRulesTable, tags]);
  const alertsPageNavigation = (0, _react.useCallback)(() => {
    history.push({
      pathname: ALERTS_PAGE_PATH
    });
  }, [history]);
  const createDetectionRuleOnClick = (0, _react.useCallback)(async () => {
    setIsCreateRuleLoading(true);
    const ruleResponse = await createRuleFn(http);
    setIsCreateRuleLoading(false);
    (0, _take_action.showCreateDetectionRuleSuccessToast)(notifications, http, ruleResponse);
    // Triggering a refetch of rules and alerts to update the UI
    queryClient.invalidateQueries([_constants.DETECTION_ENGINE_RULES_KEY]);
    queryClient.invalidateQueries([_constants.DETECTION_ENGINE_ALERTS_KEY]);
  }, [createRuleFn, http, notifications, queryClient]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "csp:detection-rule-counter-loading",
    lines: 1,
    size: "m",
    isLoading: ruleIsLoading || alertsIsLoading
  }, (rulesData === null || rulesData === void 0 ? void 0 : rulesData.total) === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, isCreateRuleLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.creatingRule",
    defaultMessage: "Creating detection rule"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "csp:findings-flyout-detection-rule-counter-loading"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: createDetectionRuleOnClick,
    "data-test-subj": "csp:findings-flyout-create-detection-rule-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.createRuleAction",
    defaultMessage: "Create a detection rule"
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.createRuleDescription",
    defaultMessage: "to generate alerts."
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: alertsPageNavigation,
    "data-test-subj": "csp:findings-flyout-alert-count"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.alertCount",
    defaultMessage: "{alertCount, plural, one {# alert} other {# alerts}}",
    values: {
      alertCount: (alertsData === null || alertsData === void 0 ? void 0 : alertsData.total) || 0
    }
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.detectedBy",
    defaultMessage: "detected by"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: rulePageNavigation,
    "data-test-subj": "csp:findings-flyout-detection-rule-count"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.detectionRuleCount",
    defaultMessage: "{ruleCount, plural, one {# detection rule} other {# detection rules}}",
    values: {
      ruleCount: (rulesData === null || rulesData === void 0 ? void 0 : rulesData.total) || 0
    }
  }))));
};
exports.DetectionRuleCounter = DetectionRuleCounter;