"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudSecurityDataTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _cellActions = require("@kbn/cell-actions");
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_kibana = require("../../common/hooks/use_kibana");
var _empty_state = require("../empty_state");
var _constants = require("../../common/constants");
var _use_styles = require("./use_styles");
var _additional_controls = require("./additional_controls");
var _data_view_context = require("../../common/contexts/data_view_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const gridStyle = {
  border: 'horizontal',
  cellPadding: 'l',
  stripes: false,
  header: 'underline'
};
const useNewFieldsApi = true;

// Hide Checkbox, enable open details Flyout
const controlColumnIds = ['openDetails'];
const CloudSecurityDataTable = ({
  isLoading,
  defaultColumns,
  rows,
  total,
  flyoutComponent,
  cloudPostureDataTable,
  loadMore,
  title,
  customCellRenderer,
  groupSelectorComponent,
  height,
  ...rest
}) => {
  const {
    columnsLocalStorageKey,
    pageSize,
    onChangeItemsPerPage,
    setUrlQuery,
    onSort,
    onResetFilters,
    filters,
    sort
  } = cloudPostureDataTable;
  const [columns, setColumns] = (0, _useLocalStorage.default)(columnsLocalStorageKey, defaultColumns.map(c => c.id));
  const [settings, setSettings] = (0, _useLocalStorage.default)(`${columnsLocalStorageKey}:settings`, {
    columns: defaultColumns.reduce((prev, curr) => {
      const columnDefaultSettings = curr.width ? {
        width: curr.width
      } : {};
      const newColumn = {
        [curr.id]: columnDefaultSettings
      };
      return {
        ...prev,
        ...newColumn
      };
    }, {})
  });
  const {
    dataView,
    dataViewIsRefetching,
    dataViewRefetch
  } = (0, _data_view_context.useDataViewContext)();
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const renderDocumentView = hit => flyoutComponent(hit, () => setExpandedDoc(undefined));

  // services needed for unified-data-table package
  const {
    uiSettings,
    uiActions,
    dataViews,
    data,
    application,
    theme,
    fieldFormats,
    toastNotifications,
    storage,
    dataViewFieldEditor
  } = (0, _use_kibana.useKibana)().services;
  const styles = (0, _use_styles.useStyles)();
  const {
    capabilities
  } = application;
  const {
    filterManager
  } = data.query;
  const services = {
    theme,
    fieldFormats,
    uiSettings,
    toastNotifications,
    storage,
    data,
    dataViewFieldEditor
  };
  const {
    columns: currentColumns,
    onSetColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState: props => setColumns(props.columns),
    useNewFieldsApi,
    columns,
    sort
  });
  const onAddFilter = (0, _react.useMemo)(() => filterManager && dataView ? (clickedField, values, operation) => {
    const newFilters = (0, _public.generateFilters)(filterManager, clickedField, values, operation, dataView);
    filterManager.addFilters(newFilters);
    setUrlQuery({
      filters: filterManager.getFilters()
    });
  } : undefined, [dataView, filterManager, setUrlQuery]);
  const onResize = colSettings => {
    const grid = settings || {};
    const newColumns = {
      ...(grid.columns || {})
    };
    newColumns[colSettings.columnId] = {
      width: Math.round(colSettings.width)
    };
    const newGrid = {
      ...grid,
      columns: newColumns
    };
    setSettings(newGrid);
  };
  const externalCustomRenderers = (0, _react.useMemo)(() => {
    if (!customCellRenderer) {
      return undefined;
    }
    return customCellRenderer(rows);
  }, [customCellRenderer, rows]);
  const onResetColumns = () => {
    setColumns(defaultColumns.map(c => c.id));
  };
  if (!isLoading && !rows.length) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters
    });
  }
  const externalAdditionalControls = /*#__PURE__*/_react.default.createElement(_additional_controls.AdditionalControls, {
    total: total,
    dataView: dataView,
    title: title,
    columns: currentColumns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    groupSelectorComponent: groupSelectorComponent,
    onResetColumns: onResetColumns
  });
  const dataTableStyle = {
    // Change the height of the grid to fit the page
    // If there are filters, leave space for the filter bar
    // Todo: Replace this component with EuiAutoSizer
    height: height !== null && height !== void 0 ? height : `calc(100vh - ${(filters === null || filters === void 0 ? void 0 : filters.length) > 0 ? 454 : 414}px)`
  };
  const rowHeightState = 0;
  const loadingStyle = {
    opacity: isLoading ? 1 : 0
  };
  const loadingState = isLoading || dataViewIsRefetching ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded;
  return /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": rest['data-test-subj'],
    className: styles.gridContainer,
    style: dataTableStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    style: loadingStyle
  }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, {
    className: styles.gridStyle,
    ariaLabelledBy: title,
    columns: currentColumns,
    expandedDoc: expandedDoc,
    dataView: dataView,
    loadingState: loadingState,
    onFilter: onAddFilter,
    onResize: onResize,
    onSetColumns: onSetColumns,
    onSort: onSort,
    rows: rows,
    sampleSizeState: _constants.MAX_FINDINGS_TO_LOAD,
    setExpandedDoc: setExpandedDoc,
    renderDocumentView: renderDocumentView,
    sort: sort,
    rowsPerPageState: pageSize,
    totalHits: total,
    services: services,
    useNewFieldsApi: true,
    onUpdateRowsPerPage: onChangeItemsPerPage,
    rowHeightState: rowHeightState,
    showMultiFields: uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    showTimeCol: false,
    settings: settings,
    onFetchMoreRecords: loadMore,
    externalCustomRenderers: externalCustomRenderers,
    externalAdditionalControls: externalAdditionalControls,
    gridStyleOverride: gridStyle,
    rowLineHeightOverride: "24px",
    controlColumnIds: controlColumnIds,
    onFieldEdited: dataViewRefetch
  })));
};
exports.CloudSecurityDataTable = CloudSecurityDataTable;