"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findCspBenchmarkRuleRequestSchema = exports.cspBenchmarkRuleSchema = exports.cspBenchmarkRuleMetadataSchema = exports.DEFAULT_BENCHMARK_RULES_PER_PAGE = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BENCHMARK_RULES_PER_PAGE = exports.DEFAULT_BENCHMARK_RULES_PER_PAGE = 25;

// Since version 8.7.0

const cspBenchmarkRuleMetadataSchema = exports.cspBenchmarkRuleMetadataSchema = _configSchema.schema.object({
  audit: _configSchema.schema.string(),
  benchmark: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    posture_type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.CSPM_POLICY_TEMPLATE), _configSchema.schema.literal(_constants.KSPM_POLICY_TEMPLATE)])),
    id: _configSchema.schema.string(),
    version: _configSchema.schema.string(),
    rule_number: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  default_value: _configSchema.schema.maybe(_configSchema.schema.string()),
  description: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  impact: _configSchema.schema.maybe(_configSchema.schema.string()),
  name: _configSchema.schema.string(),
  profile_applicability: _configSchema.schema.string(),
  rationale: _configSchema.schema.string(),
  references: _configSchema.schema.maybe(_configSchema.schema.string()),
  rego_rule_id: _configSchema.schema.string(),
  remediation: _configSchema.schema.string(),
  section: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  version: _configSchema.schema.string()
});
const cspBenchmarkRuleSchema = exports.cspBenchmarkRuleSchema = _configSchema.schema.object({
  metadata: cspBenchmarkRuleMetadataSchema
});
const findCspBenchmarkRuleRequestSchema = exports.findCspBenchmarkRuleRequestSchema = _configSchema.schema.object({
  /**
   * An Elasticsearch simple_query_string
   */
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  /**
   * The page of objects to return
   */
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  /**
   * The number of objects to include in each page
   */
  perPage: _configSchema.schema.number({
    defaultValue: DEFAULT_BENCHMARK_RULES_PER_PAGE,
    min: 0
  }),
  /**
   *  Fields to retrieve from CspBenchmarkRule saved object
   */
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  /**
   *  The fields to perform the parsed query against.
   * Valid fields are fields which mapped to 'text' in cspBenchmarkRuleSavedObjectMapping
   */
  searchFields: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('metadata.name.text'), _configSchema.schema.literal('metadata.section.text')]), {
    defaultValue: ['metadata.name.text']
  }),
  /**
   *  Sort Field
   */
  sortField: _configSchema.schema.oneOf([_configSchema.schema.literal('metadata.name'), _configSchema.schema.literal('metadata.section'), _configSchema.schema.literal('metadata.id'), _configSchema.schema.literal('metadata.version'), _configSchema.schema.literal('metadata.benchmark.id'), _configSchema.schema.literal('metadata.benchmark.name'), _configSchema.schema.literal('metadata.benchmark.posture_type'), _configSchema.schema.literal('metadata.benchmark.version'), _configSchema.schema.literal('metadata.benchmark.rule_number')], {
    defaultValue: 'metadata.benchmark.rule_number'
  }),
  /**
   * The order to sort by
   */
  sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'asc'
  }),
  /**
   * benchmark id
   */
  benchmarkId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('cis_k8s'), _configSchema.schema.literal('cis_eks'), _configSchema.schema.literal('cis_aws'), _configSchema.schema.literal('cis_azure'), _configSchema.schema.literal('cis_gcp')])),
  /**
   * package_policy_id
   */
  packagePolicyId: _configSchema.schema.maybe(_configSchema.schema.string()),
  /**
   * rule section
   */
  section: _configSchema.schema.maybe(_configSchema.schema.string())
});