"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfigModel = void 0;
var _react = require("react");
var _monaco = require("@kbn/monaco");
var _helpers = require("../../../../common/utils/helpers");
var _policy_schema = _interopRequireDefault(require("./policy_schema.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * In order to keep this json in sync with https://github.com/elastic/cloud-defend/blob/main/modules/config/policy-schema.json
 * Do NOT commit edits to policy_schema.json as part of a PR. Please make the changes in the cloud-defend repo.
 * Buildkite will take care of creating a PR in kibana.
 */

const {
  Uri,
  editor
} = _monaco.monaco;
const SCHEMA_URI = 'http://elastic.co/cloud_defend.json';
const modelUri = Uri.parse(SCHEMA_URI);
const useConfigModel = configuration => {
  const [configModel, setConfigModel] = (0, _react.useState)(null);
  const schema = (0, _react.useMemo)(() => {
    const _schema = {
      ..._policy_schema.default
    };
    const {
      selectors
    } = (0, _helpers.getSelectorsAndResponsesFromYaml)(configuration);

    // dynamically setting enum values for response match and exclude properties.
    if (_schema.$defs.fileResponse.properties.match.items) {
      const responseProps = _schema.$defs.fileResponse.properties;
      const selectorEnum = {
        enum: selectors.filter(selector => selector.type === 'file').map(selector => selector.name)
      };
      responseProps.match.items = selectorEnum;
      responseProps.exclude.items = selectorEnum;
    }
    if (_schema.$defs.processResponse.properties.match.items) {
      const responseProps = _schema.$defs.processResponse.properties;
      const selectorEnum = {
        enum: selectors.filter(selector => selector.type === 'process').map(selector => selector.name)
      };
      responseProps.match.items = selectorEnum;
      responseProps.exclude.items = selectorEnum;
    }
    return _schema;
  }, [configuration]);
  (0, _react.useEffect)(() => {
    async function configureMonacoYaml(...args) {
      const {
        dispose
      } = await (0, _monaco.configureMonacoYamlSchema)(...args);
      let model = editor.getModel(modelUri);
      if (model === null) {
        model = editor.createModel('', _monaco.YAML_LANG_ID, modelUri);
      }
      setConfigModel(model);
      return () => dispose();
    }
    configureMonacoYaml([{
      uri: SCHEMA_URI,
      fileMatch: [String(modelUri)],
      schema
    }]);
  }, [schema]);
  return configModel;
};
exports.useConfigModel = useConfigModel;