"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatHeaderMenuItem = ChatHeaderMenuItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _chat_icon_dark = _interopRequireDefault(require("./chat_icon_dark.svg"));
var _chat_icon_light = _interopRequireDefault(require("./chat_icon_light.svg"));
var _chat = require("../chat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatHeaderMenuItem() {
  const [showChatButton, setChatButtonShow] = _react.default.useState(false);
  const [chatApi, setChatApi] = _react.default.useState(null);
  const [showTour, setShowTour] = (0, _useLocalStorage.default)('cloudChatTour', true);
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const ref = _react.default.useRef(null);

  // chat top offset is used to properly position the chat widget
  // it can't be static because of an edge case with banners
  const [chatTopOffset, setChatTopOffset] = _react.default.useState(0);
  _react.default.useEffect(() => {
    const chatButton = ref.current;
    if (!chatButton) return;
    const chatButtonClientRect = chatButton.getBoundingClientRect();
    setChatTopOffset(chatButtonClientRect.top + chatButtonClientRect.height - 8);
  }, [showChatButton]);
  const isLargeScreen = (0, _eui.useIsWithinMinBreakpoint)('m');
  if (!isLargeScreen) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showChatButton && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: colorMode === 'DARK' ? _chat_icon_light.default : _chat_icon_dark.default,
      size: 'l',
      css: {
        marginRight: euiTheme.size.s
      }
    }), _i18n.i18n.translate('xpack.cloudChat.chatTourHeaderText', {
      defaultMessage: 'Live Chat Now'
    })),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's'
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.cloudChat.chatTourText', {
      defaultMessage: 'Open chat for assistance with topics such as ingesting data, configuring your instance, and troubleshooting.'
    }))),
    isStepOpen: showTour,
    onFinish: () => setShowTour(false),
    minWidth: 300,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    buttonRef: ref,
    css: {
      color: euiTheme.colors.ghost,
      marginRight: euiTheme.size.m
    },
    size: "s",
    iconType: _chat_icon_light.default,
    "data-test-subj": "cloud-chat",
    onClick: () => {
      if (showTour) setShowTour(false);
      chatApi === null || chatApi === void 0 ? void 0 : chatApi.toggle();
    }
  }, _i18n.i18n.translate('xpack.cloudChat.chatButtonLabel', {
    defaultMessage: 'Live Chat'
  }))), /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement(_chat.Chat, {
    onReady: _chatApi => {
      setChatApi(_chatApi);
    },
    onPlaybookFired: () => {
      setChatButtonShow(true);
    },
    topOffset: chatTopOffset
  }), document.body));
}