"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceCustomFieldRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const replaceCustomFieldRoute = exports.replaceCustomFieldRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'put',
  path: _constants.INTERNAL_PUT_CUSTOM_FIELDS_URL,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string(),
      custom_field_id: _configSchema.schema.string()
    })
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const caseId = request.params.case_id;
      const customFieldId = request.params.custom_field_id;
      const details = request.body;
      const res = await casesClient.cases.replaceCustomField({
        caseId,
        customFieldId,
        request: details
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to replace customField in route: ${error}`,
        error
      });
    }
  }
});