"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetCasesRoute = void 0;
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkGetCasesRoute = exports.bulkGetCasesRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_BULK_GET_CASES_URL,
  params: {
    body: _utils.escapeHatch
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    const params = request.body;
    try {
      const casesContext = await context.cases;
      const casesClient = await casesContext.getCasesClient();
      const res = await casesClient.cases.bulkGet({
        ...params
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      var _params$ids;
      const ids = (_params$ids = params.ids) !== null && _params$ids !== void 0 ? _params$ids : [];
      throw (0, _error.createCaseError)({
        message: `Failed to bulk get cases in route: ${ids.join(', ')}: ${error}`,
        error
      });
    }
  }
});