"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pushCaseRoute = void 0;
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _api = require("../../../../common/types/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pushCaseRoute = exports.pushCaseRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASE_PUSH_URL,
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const params = (0, _runtime_types.decodeWithExcessOrThrow)(_api.caseApiV1.CasePushRequestParamsRt)(request.params);
      const res = await casesClient.cases.push({
        caseId: params.case_id,
        connectorId: params.connector_id
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to push case in route: ${error}`,
        error
      });
    }
  }
});