"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionRecordsByError = exports.partitionByNonFoundErrors = exports.isRecordError = exports.convertValueToString = exports.constructRequiredKibanaPrivileges = exports.buildRequiredCustomFieldsForRequest = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isRecordError = so => so.error != null;
exports.isRecordError = isRecordError;
const partitionRecordsByError = res => {
  const [errors, validRecords] = (0, _lodash.partition)(res, isRecordError);
  return [validRecords, errors];
};
exports.partitionRecordsByError = partitionRecordsByError;
const partitionByNonFoundErrors = errors => {
  const [nonFoundErrors, restOfErrors] = (0, _lodash.partition)(errors, error => error.statusCode === 404);
  return [nonFoundErrors, restOfErrors];
};
exports.partitionByNonFoundErrors = partitionByNonFoundErrors;
const convertValueToString = value => {
  if (value == null) {
    return '';
  }
  if (Array.isArray(value) || (0, _lodash.isPlainObject)(value)) {
    try {
      return JSON.stringify(value);
    } catch (error) {
      return '';
    }
  }
  return (0, _lodash.toString)(value);
};
exports.convertValueToString = convertValueToString;
const buildRequiredCustomFieldsForRequest = customFieldsConfiguration => {
  // only populate with the default value required custom fields missing from the request
  return customFieldsConfiguration ? customFieldsConfiguration.filter(customFieldConfig => customFieldConfig.required).map(customFieldConfig => {
    let value = null;
    if (customFieldConfig.type in _constants.VALUES_FOR_CUSTOM_FIELDS_MISSING_DEFAULTS) {
      value = customFieldConfig.defaultValue === undefined || (customFieldConfig === null || customFieldConfig === void 0 ? void 0 : customFieldConfig.defaultValue) === null ? _constants.VALUES_FOR_CUSTOM_FIELDS_MISSING_DEFAULTS[customFieldConfig.type] : customFieldConfig === null || customFieldConfig === void 0 ? void 0 : customFieldConfig.defaultValue;
    }
    return {
      key: customFieldConfig.key,
      type: customFieldConfig.type,
      value
    };
  }) : [];
};
exports.buildRequiredCustomFieldsForRequest = buildRequiredCustomFieldsForRequest;
const constructRequiredKibanaPrivileges = owner => {
  /**
   * Kibana features privileges are defined in
   * x-pack/plugins/security/server/authorization/privileges/feature_privilege_builder/cases.ts
   */
  return [`cases:${owner}/createCase`, `cases:${owner}/updateCase`, `cases:${owner}/deleteCase`, `cases:${owner}/pushCase`, `cases:${owner}/createComment`, `cases:${owner}/updateComment`, `cases:${owner}/deleteComment`, `cases:${owner}/findConfigurations`];
};
exports.constructRequiredKibanaPrivileges = constructRequiredKibanaPrivileges;