"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesConnectorType = exports.getCasesConnectorAdapter = void 0;
var _common = require("@kbn/actions-plugin/common");
var _cases_connector = require("./cases_connector");
var _constants = require("./constants");
var _constants2 = require("../../../common/constants");
var _schema = require("./schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesConnectorType = ({
  getCasesClient,
  getSpaceId,
  getUnsecuredSavedObjectsClient
}) => ({
  id: _constants2.CASES_CONNECTOR_ID,
  name: _constants2.CASES_CONNECTOR_TITLE,
  getService: params => new _cases_connector.CasesConnector({
    casesParams: {
      getCasesClient,
      getSpaceId,
      getUnsecuredSavedObjectsClient
    },
    connectorParams: params
  }),
  schema: {
    config: _schema.CasesConnectorConfigSchema,
    secrets: _schema.CasesConnectorSecretsSchema
  },
  supportedFeatureIds: [_common.UptimeConnectorFeatureId, _common.AlertingConnectorFeatureId],
  minimumLicenseRequired: 'platinum',
  isSystemActionType: true,
  getKibanaPrivileges: ({
    params
  } = {
    params: {
      subAction: 'run',
      subActionParams: {}
    }
  }) => {
    var _params$subActionPara;
    const owner = params === null || params === void 0 ? void 0 : (_params$subActionPara = params.subActionParams) === null || _params$subActionPara === void 0 ? void 0 : _params$subActionPara.owner;
    if (!owner) {
      throw new Error('Cannot authorize cases. Owner is not defined in the subActionParams.');
    }
    return (0, _utils.constructRequiredKibanaPrivileges)(owner);
  }
});
exports.getCasesConnectorType = getCasesConnectorType;
const getCasesConnectorAdapter = () => {
  return {
    connectorTypeId: _constants2.CASES_CONNECTOR_ID,
    ruleActionParamsSchema: _schema.CasesConnectorRuleActionParamsSchema,
    buildActionParams: ({
      alerts,
      rule,
      params,
      spaceId,
      ruleUrl
    }) => {
      const caseAlerts = [...alerts.new.data, ...alerts.ongoing.data];
      const owner = getOwnerFromRuleConsumerProducer(rule.consumer, rule.producer);
      const subActionParams = {
        alerts: caseAlerts,
        rule: {
          id: rule.id,
          name: rule.name,
          tags: rule.tags,
          ruleUrl: ruleUrl !== null && ruleUrl !== void 0 ? ruleUrl : null
        },
        groupingBy: params.subActionParams.groupingBy,
        owner,
        reopenClosedCases: params.subActionParams.reopenClosedCases,
        timeWindow: params.subActionParams.timeWindow,
        maximumCasesToOpen: _constants.DEFAULT_MAX_OPEN_CASES
      };
      return {
        subAction: 'run',
        subActionParams
      };
    },
    getKibanaPrivileges: ({
      consumer,
      producer
    }) => {
      const owner = getOwnerFromRuleConsumerProducer(consumer, producer);
      return (0, _utils.constructRequiredKibanaPrivileges)(owner);
    }
  };
};
exports.getCasesConnectorAdapter = getCasesConnectorAdapter;
const getOwnerFromRuleConsumerProducer = (consumer, producer) => {
  for (const value of Object.values(_constants2.OWNER_INFO)) {
    var _value$validRuleConsu;
    const foundedConsumer = (_value$validRuleConsu = value.validRuleConsumers) === null || _value$validRuleConsu === void 0 ? void 0 : _value$validRuleConsu.find(validConsumer => validConsumer === consumer || validConsumer === producer);
    if (foundedConsumer) {
      return value.id;
    }
  }
  return _constants2.OWNER_INFO.cases.id;
};