"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCustomFieldTypesInRequest = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Throws an error if the request tries to change the type of existing custom fields.
 */
const validateCustomFieldTypesInRequest = ({
  requestCustomFields,
  originalCustomFields
}) => {
  if (!Array.isArray(requestCustomFields) || !originalCustomFields.length) {
    return;
  }
  const invalidFields = [];
  requestCustomFields.forEach(requestField => {
    const originalField = originalCustomFields.find(item => item.key === requestField.key);
    if (originalField && originalField.type !== requestField.type) {
      invalidFields.push(`"${requestField.label}"`);
    }
  });
  if (invalidFields.length > 0) {
    throw _boom.default.badRequest(`Invalid custom field types in request for the following labels: ${invalidFields.join(', ')}`);
  }
};
exports.validateCustomFieldTypesInRequest = validateCustomFieldTypesInRequest;