"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfiniteFindCaseUserActions = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("./api");
var _use_cases_toast = require("../common/use_cases_toast");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfiniteFindCaseUserActions = (caseId, params, isEnabled) => {
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  const abortCtrlRef = new AbortController();
  return (0, _reactQuery.useInfiniteQuery)(_constants.casesQueriesKeys.caseUserActions(caseId, params), async ({
    pageParam = 1
  }) => {
    return (0, _api.findCaseUserActions)(caseId, {
      ...params,
      page: pageParam
    }, abortCtrlRef.signal);
  }, {
    enabled: isEnabled,
    onError: error => {
      showErrorToast(error, {
        title: _translations.ERROR_TITLE
      });
    },
    getNextPageParam: (lastPage, pages) => {
      const lastPageNumber = Math.ceil(lastPage.total / lastPage.perPage);
      // here last page fetching is skipped because last page is fetched separately using useQuery hook
      if (lastPage.page < lastPageNumber - 1) {
        return lastPage.page + 1;
      }
      return undefined;
    }
  });
};
exports.useInfiniteFindCaseUserActions = useInfiniteFindCaseUserActions;