"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortProfiles = exports.orderAssigneesIncludingNone = exports.moveCurrentUserToBeginning = exports.getSortField = exports.bringCurrentUserToFrontAndSort = void 0;
var _lodash = require("lodash");
var _assignees_filter = require("../all_cases/assignees_filter");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSortField = profile => {
  var _ref, _ref2, _profile$user$full_na, _profile$user, _profile$user$full_na2, _profile$user2, _profile$user2$email, _profile$user3;
  return (_ref = (_ref2 = (_profile$user$full_na = (_profile$user = profile.user) === null || _profile$user === void 0 ? void 0 : (_profile$user$full_na2 = _profile$user.full_name) === null || _profile$user$full_na2 === void 0 ? void 0 : _profile$user$full_na2.toLowerCase()) !== null && _profile$user$full_na !== void 0 ? _profile$user$full_na : (_profile$user2 = profile.user) === null || _profile$user2 === void 0 ? void 0 : (_profile$user2$email = _profile$user2.email) === null || _profile$user2$email === void 0 ? void 0 : _profile$user2$email.toLowerCase()) !== null && _ref2 !== void 0 ? _ref2 : (_profile$user3 = profile.user) === null || _profile$user3 === void 0 ? void 0 : _profile$user3.username.toLowerCase()) !== null && _ref !== void 0 ? _ref : _translations.UNKNOWN;
};
exports.getSortField = getSortField;
const moveCurrentUserToBeginning = (currentUserProfile, profiles) => {
  if (!profiles) {
    return;
  }
  if (!currentUserProfile) {
    return profiles;
  }
  const currentProfileIndex = profiles.find(profile => profile.uid === currentUserProfile.uid);
  if (!currentProfileIndex) {
    return profiles;
  }
  const profilesWithoutCurrentUser = profiles.filter(profile => profile.uid !== currentUserProfile.uid);
  return [currentUserProfile, ...profilesWithoutCurrentUser];
};
exports.moveCurrentUserToBeginning = moveCurrentUserToBeginning;
const bringCurrentUserToFrontAndSort = (currentUserProfile, profiles) => moveCurrentUserToBeginning(currentUserProfile, sortProfiles(profiles));
exports.bringCurrentUserToFrontAndSort = bringCurrentUserToFrontAndSort;
const sortProfiles = profiles => {
  if (!profiles) {
    return;
  }
  return (0, _lodash.sortBy)(profiles, getSortField);
};
exports.sortProfiles = sortProfiles;
const orderAssigneesIncludingNone = (currentUserProfile, assignees) => {
  var _bringCurrentUserToFr;
  const usersWithNoAssigneeSelection = removeNoAssigneesSelection(assignees);
  const sortedUsers = (_bringCurrentUserToFr = bringCurrentUserToFrontAndSort(currentUserProfile, usersWithNoAssigneeSelection)) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
  const hasNoAssigneesSelection = assignees.find(assignee => assignee === _assignees_filter.NO_ASSIGNEES_VALUE);
  const sortedUsersWithNoAssigneeIfExisted = hasNoAssigneesSelection !== undefined ? [_assignees_filter.NO_ASSIGNEES_VALUE, ...sortedUsers] : sortedUsers;
  return sortedUsersWithNoAssigneeIfExisted;
};
exports.orderAssigneesIncludingNone = orderAssigneesIncludingNone;
const removeNoAssigneesSelection = assignees => assignees.filter(assignee => assignee !== _assignees_filter.NO_ASSIGNEES_VALUE);