"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverableAvatar = void 0;
var _react = _interopRequireDefault(require("react"));
var _user_avatar = require("./user_avatar");
var _user_tooltip = require("./user_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverableAvatarComponent = ({
  userInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
    userInfo: userInfo
  }, /*#__PURE__*/_react.default.createElement(_user_avatar.CaseUserAvatar, {
    size: 'm',
    userInfo: userInfo
  }));
};
HoverableAvatarComponent.displayName = 'HoverableAvatar';
const HoverableAvatar = exports.HoverableAvatar = /*#__PURE__*/_react.default.memo(HoverableAvatarComponent);