"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesTitleBreadcrumbs = exports.useCasesBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _navigation = require("../../common/navigation");
var _use_application = require("../../common/lib/kibana/use_application");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesBreadcrumbTitle = {
  [_navigation.CasesDeepLinkId.cases]: _i18n.i18n.translate('xpack.cases.breadcrumbs.all_cases', {
    defaultMessage: 'Cases'
  }),
  [_navigation.CasesDeepLinkId.casesCreate]: _i18n.i18n.translate('xpack.cases.breadcrumbs.create_case', {
    defaultMessage: 'Create'
  }),
  [_navigation.CasesDeepLinkId.casesConfigure]: _i18n.i18n.translate('xpack.cases.breadcrumbs.settings', {
    defaultMessage: 'Settings'
  })
};
function getTitleFromBreadcrumbs(breadcrumbs) {
  return breadcrumbs.map(({
    text
  }) => {
    var _text$toString;
    return (_text$toString = text === null || text === void 0 ? void 0 : text.toString()) !== null && _text$toString !== void 0 ? _text$toString : '';
  }).reverse();
}
const useApplyBreadcrumbs = () => {
  const {
    chrome: {
      docTitle,
      setBreadcrumbs
    },
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  return (0, _react.useCallback)(breadcrumbs => {
    docTitle.change(getTitleFromBreadcrumbs(breadcrumbs));
    setBreadcrumbs(breadcrumbs.map(breadcrumb => {
      const {
        href,
        onClick
      } = breadcrumb;
      return {
        ...breadcrumb,
        ...(href && !onClick ? {
          onClick: event => {
            if (event) {
              event.preventDefault();
            }
            navigateToUrl(href);
          }
        } : {})
      };
    }));
  }, [docTitle, setBreadcrumbs, navigateToUrl]);
};
const useCasesBreadcrumbs = pageDeepLink => {
  const {
    appId,
    appTitle
  } = (0, _use_application.useApplication)();
  const {
    getAppUrl
  } = (0, _kibana.useNavigation)(appId);
  const applyBreadcrumbs = useApplyBreadcrumbs();
  (0, _react.useEffect)(() => {
    var _KibanaServices$get$s;
    applyBreadcrumbs([{
      text: appTitle,
      href: getAppUrl()
    }, {
      text: casesBreadcrumbTitle[_navigation.CasesDeepLinkId.cases],
      ...(pageDeepLink !== _navigation.CasesDeepLinkId.cases ? {
        href: getAppUrl({
          deepLinkId: _navigation.CasesDeepLinkId.cases
        })
      } : {})
    }, ...(pageDeepLink !== _navigation.CasesDeepLinkId.cases ? [{
      text: casesBreadcrumbTitle[pageDeepLink]
    }] : [])]);
    (_KibanaServices$get$s = _kibana.KibanaServices.get().serverless) === null || _KibanaServices$get$s === void 0 ? void 0 : _KibanaServices$get$s.setBreadcrumbs([]);
  }, [pageDeepLink, appTitle, getAppUrl, applyBreadcrumbs]);
};
exports.useCasesBreadcrumbs = useCasesBreadcrumbs;
const useCasesTitleBreadcrumbs = caseTitle => {
  const {
    appId,
    appTitle
  } = (0, _use_application.useApplication)();
  const {
    getAppUrl
  } = (0, _kibana.useNavigation)(appId);
  const applyBreadcrumbs = useApplyBreadcrumbs();
  (0, _react.useEffect)(() => {
    var _KibanaServices$get$s2;
    const titleBreadcrumb = {
      text: caseTitle
    };
    const casesBreadcrumbs = [{
      text: appTitle,
      href: getAppUrl()
    }, {
      text: casesBreadcrumbTitle[_navigation.CasesDeepLinkId.cases],
      href: getAppUrl({
        deepLinkId: _navigation.CasesDeepLinkId.cases
      })
    }, titleBreadcrumb];
    applyBreadcrumbs(casesBreadcrumbs);
    (_KibanaServices$get$s2 = _kibana.KibanaServices.get().serverless) === null || _KibanaServices$get$s2 === void 0 ? void 0 : _KibanaServices$get$s2.setBreadcrumbs([titleBreadcrumb]);
  }, [caseTitle, appTitle, getAppUrl, applyBreadcrumbs]);
};
exports.useCasesTitleBreadcrumbs = useCasesTitleBreadcrumbs;